/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/util/DltName.h"
#include <cstring>

namespace hmibase {
namespace util {


DltName::DltName()
{
   clear();
}


DltName::DltName(const char* name)
{
   *this = name;
}


DltName::DltName(const DltName& name)
{
   *this = name;
}


DltName::~DltName()
{
}


const char* DltName::cPtr() const
{
   return mName;
}


void DltName::clear()
{
   memset(mName, 0, 5);
}


DltName& DltName::operator=(const char* right)
{
   clear();
   if (right != NULL)
   {
      int i = 0;
      while (i < 4 && right[i] != 0)
      {
         mName[i] = right[i];
         i++;
      }
   }
   return *this;
}


DltName& DltName::operator=(const DltName& right)
{
   if (this != &right)
   {
      memcpy(mName, right.mName, 5);
      mName[4] = 0;
   }
   return *this;
}


int DltName::compare(const DltName& right) const
{
   for (int i = 0; i < 4; i++)
   {
      if (mName[i] < right.mName[i])
      {
         return -1;
      }

      if (mName[i] > right.mName[i])
      {
         return 1;
      }
   }
   return 0;
}


bool DltName::operator==(const DltName& right) const
{
   return compare(right) == 0;
}


bool DltName::operator!=(const DltName& right) const
{
   return compare(right) != 0;
}


bool DltName::operator<=(const DltName& right) const
{
   return compare(right) <= 0;
}


bool DltName::operator>=(const DltName& right) const
{
   return compare(right) >= 0;
}


bool DltName::operator<(const DltName& right) const
{
   return compare(right) < 0;
}


bool DltName::operator>(const DltName& right) const
{
   return compare(right) > 0;
}


} // namespace
} // namespace
