/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/util/DltApplication.h"
#include "hmibase/util/Macros.h"
#include <string.h>
#include <iostream>

#ifdef VARIANT_S_FTR_ENABLE_ETG_TO_DLT
#include <dlt/dlt.h>
#endif


namespace hmibase {
namespace util {


DltApplication::DltApplication(const char* name, const char* description)
{
   if (checkLibraryVersion())
   {
      registerApp(name, description);
   }
}


DltApplication::~DltApplication()
{
   unregisterApp();
}


/*
DltName DltApplication::getNamexxx()
{
   char name[5];
   memset(name, 0, 5);
#ifdef VARIANT_S_FTR_ENABLE_ETG_TO_DLT
  // dlt_get_appid(name);
#endif
   return name;
}


*/

bool DltApplication::checkLibraryVersion()
{
#ifdef VARIANT_S_FTR_ENABLE_ETG_TO_DLT
   DltReturnValue value = dlt_check_library_version(_DLT_PACKAGE_MAJOR_VERSION, _DLT_PACKAGE_MINOR_VERSION);

   PARAM_UNUSED(value);
//   std::cout << "dlt_check_library_version returned " << value << std::endl;
//   std::cout.flush();
#endif
   return true;
}


void DltApplication::registerApp(const DltName& name, const char* description)
{
#ifdef VARIANT_S_FTR_ENABLE_ETG_TO_DLT
   DltReturnValue value = dlt_register_app(name.cPtr(), description);

   PARAM_UNUSED(value);
//   std::cout << "dlt_register_app returned " << value << std::endl;
//   std::cout.flush();
#else
   PARAM_UNUSED(name);
   PARAM_UNUSED(description);
#endif
}


void DltApplication::unregisterApp()
{
#ifdef VARIANT_S_FTR_ENABLE_ETG_TO_DLT
   DltReturnValue value = dlt_unregister_app();

   PARAM_UNUSED(value);
//   std::cout << "dlt_unregister_app returned " << value << std::endl;
//   std::cout.flush();
#endif
}


} // namespace
} // namespace
