/* ***************************************************************************************
* FILE:          Assert.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Assert.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef WIN32

#include "hmibase/util/Assert.h"
#define OSAL_S_IMPORT_INTERFACE_ANSI
#include "osal_if.h"

#ifdef VARIANT_S_FTR_ENABLE_BOSCH_HMI_ALERT
#include "Trace/HMIAlert.h"
#endif

#include "hmibase/util/Trace.h"
#include "hmibase/util/TraceUtils.h"
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW_UTIL
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/Assert.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace hmibase {
namespace util {

void Assert(const char* expression, const char* filename, unsigned int linenumber)
{
   ETG_TRACE_FATAL_THR(("[%20s] HMIBASE ASSERT: expression '%s'", hmibase::trace::getAppName().c_str(), expression));
   ETG_TRACE_FATAL_THR(("[%20s] HMIBASE ASSERT: \t-> line %u file %s", hmibase::trace::getAppName().c_str(), linenumber, filename));

#ifdef VARIANT_S_FTR_ENABLE_BOSCH_HMI_ALERT
   ::hmibase::trace::HMIAlert(filename, linenumber, expression);
#endif
#ifdef _LINUXX86_64_
   __assert(expression, filename, linenumber & (~0x80000000));
#elif LinuxX86Make
   // _assert(expression, filename, linenumber & (~0x80000000));
#else
   // FATAL_M_ASSERT
   OSAL_vAssertFunction(expression, filename, linenumber & (~0x80000000));
   // NORMAL_M_ASSERT
   //OSAL_vAssertFunction(expression, filename, linenumber & (0x80000000));
#endif
}


}
}


#endif
