/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_SYNCBLOCK2_SOCKS_LISTENINGSOCKET_H
#define HMIBASE_GADGET_SYNCBLOCK2_SOCKS_LISTENINGSOCKET_H

#include "hmibase/gadget/syncblock2/socks/Socket.h"
#include "hmibase/util/SimpleString.h"

using namespace hmibase::util;

namespace hmibase {
namespace gadget {
namespace syncblock2 {
namespace socks {

class ListeningSocket
{
   public:
      ListeningSocket(const int key);
      virtual ~ListeningSocket();

      bool tryAccept(Socket& socket);

   private:
      int mKey;
      int mSocketFd;

      bool exists() const;
      void create();
      void destroy();
      void purge();

      // Thou shalt not copy
      ListeningSocket(const ListeningSocket&);
      ListeningSocket& operator=(const ListeningSocket&);
};


} // namespace
} // namespace
} // namespace
} // namespace

#endif
