/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_SYNCBLOCK2_SOCKS_HELLOMESSAGE_H
#define HMIBASE_GADGET_SYNCBLOCK2_SOCKS_HELLOMESSAGE_H

#include "hmibase/gadget/syncblock2/socks/Message.h"
#include "hmibase/gadget/syncblock2/BufferInfo.h"
#include "hmibase/gadget/syncblock2/ProducerType.h"

namespace hmibase {
namespace gadget {
namespace syncblock2 {
namespace socks {

class HelloMessage : public Message
{
   public:
      HelloMessage();
      virtual ~HelloMessage();

      int getInstanceId() const;
      void setInstanceId(int instanceId);

      hmibase::gadget::syncblock2::ProducerType getProducerType() const;
      void setProducerType(hmibase::gadget::syncblock2::ProducerType producerType);

      const hmibase::gadget::syncblock2::BufferInfo& getBufferInfo() const;
      void setBufferInfo(const hmibase::gadget::syncblock2::BufferInfo& bufferInfo);

   private:
      int*                                       mInstanceIdPtr;
      hmibase::gadget::syncblock2::ProducerType* mProducerTypePtr;
      hmibase::gadget::syncblock2::BufferInfo*   mBufferInfoPtr;

      static hmibase::gadget::syncblock2::BufferInfo smEmptyBufferInfo;
};


} // namespace
} // namespace
} // namespace
} // namespace

#endif
