/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/syncblock2/socks/HelloMessage.h"

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#include "trcGenProj/Header/HelloMessage.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

using namespace hmibase::gadget::syncblock2;

namespace hmibase {
namespace gadget {
namespace syncblock2 {
namespace socks {


hmibase::gadget::syncblock2::BufferInfo HelloMessage::smEmptyBufferInfo;


HelloMessage::HelloMessage()
   : Message(sizeof(int) + sizeof(ProducerType) + sizeof(BufferInfo), 3)
   , mInstanceIdPtr(NULL)
   , mProducerTypePtr(NULL)
   , mBufferInfoPtr(NULL)
{
   char* cDataPtr = (char*)getDataPtr();

   if (cDataPtr != NULL)
   {
      mInstanceIdPtr = (int*)cDataPtr;
      cDataPtr += sizeof(int);

      mProducerTypePtr = (ProducerType*)cDataPtr;
      cDataPtr += sizeof(ProducerType);

      mBufferInfoPtr = (BufferInfo*)cDataPtr;
   }
}


HelloMessage::~HelloMessage()
{
}


int HelloMessage::getInstanceId() const
{
   if (mInstanceIdPtr != NULL)
   {
      return *mInstanceIdPtr;
   }
   return 0;
}


void HelloMessage::setInstanceId(int instanceId)
{
   if (mInstanceIdPtr != NULL)
   {
      *mInstanceIdPtr = instanceId;
   }
}


ProducerType HelloMessage::getProducerType() const
{
   if (mProducerTypePtr != NULL)
   {
      return *mProducerTypePtr;
   }
   return INVALID_PRODUCER;
}


void HelloMessage::setProducerType(ProducerType producerType)
{
   if (mProducerTypePtr != NULL)
   {
      *mProducerTypePtr = producerType;
   }
}


const BufferInfo& HelloMessage::getBufferInfo() const
{
   if (mBufferInfoPtr != NULL)
   {
      return *mBufferInfoPtr;
   }
   return smEmptyBufferInfo;
}


void HelloMessage::setBufferInfo(const BufferInfo& bufferInfo)
{
   if (mBufferInfoPtr != NULL)
   {
      *mBufferInfoPtr = bufferInfo;
   }
}


} // namespace
} // namespace
} // namespace
} // namespace
