/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/syncblock2/socks/GiveBufferMessage.h"

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#include "trcGenProj/Header/GiveBufferMessage.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN


namespace hmibase {
namespace gadget {
namespace syncblock2 {
namespace socks {

GiveBufferMessage::GiveBufferMessage()
   : Message(sizeof(int), 0)
   , mBufferIndexPtr(NULL)
{
   char* cDataPtr = (char*)getDataPtr();

   if (cDataPtr != NULL)
   {
      mBufferIndexPtr = (int*)cDataPtr;
   }
}


GiveBufferMessage::~GiveBufferMessage()
{
}


int GiveBufferMessage::getBufferIndex() const
{
   if (mBufferIndexPtr != NULL)
   {
      return *mBufferIndexPtr;
   }
   return 0;
}


void GiveBufferMessage::setBufferIndex(int bufferId)
{
   if (mBufferIndexPtr != NULL)
   {
      *mBufferIndexPtr = bufferId;
   }
}


} // namespace
} // namespace
} // namespace
} // namespace
