/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_SYNCBLOCK2_SOCKETCONSUMERINST_H
#define HMIBASE_GADGET_SYNCBLOCK2_SOCKETCONSUMERINST_H

#include "hmibase/gadget/syncblock2/ConsumerInst.h"
#include "hmibase/gadget/syncblock2/socks/Socket.h"
#include "hmibase/util/FixedSizeMutex.h"
#include "hmibase/util/SimpleThread.h"
#include "hmibase/util/Threadable.h"
#include <list>

namespace hmibase {
namespace gadget {
namespace syncblock2 {

class SocketConsumerInst : public ConsumerInst, public hmibase::util::Threadable
{
   public:
      SocketConsumerInst(int key, int instanceId, int fd0, int fd1, int fd2, const BufferInfo& bufferInfo, socks::Socket* socketPtr);
      virtual ~SocketConsumerInst();

      // Implement Threadable
      virtual void onStart(const bool& keepRunning);
      virtual bool onRun(const bool& keepRunning);
      virtual void onFinish(const bool& keepRunning);

      int  exchange();
      bool isUpdated();
      void clearUpdatedFlag();
      virtual bool isTerminated();

   private:
      int                     mBufferId;
      bool                    mIsUpdated;
      socks::Socket*          mSocketPtr;
      hmibase::util::FixedSizeMutex mMutex;
      hmibase::util::SimpleThread   mThread;
      std::list<int>          mBuffersNew;
      std::list<int>          mBuffersOld;

      bool sendBufferId(int  bufferId);
      bool receiveBufferId(int& bufferId);

      static int popFront(std::list<int>& buffers);
      static int popBack(std::list<int>& buffers);

      // Thou shalt not copy
      SocketConsumerInst(const SocketConsumerInst&);
      SocketConsumerInst& operator=(const SocketConsumerInst&);
};


} // namespace
} // namespace
} // namespace

#endif
