/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_SYNCBLOCK2_SHMPRODUCERINST_H
#define HMIBASE_GADGET_SYNCBLOCK2_SHMPRODUCERINST_H

#include "hmibase/gadget/syncblock2/ProducerInst.h"
#include "hmibase/gadget/syncblock2/BufferStatus.h"
#include "hmibase/gadget/syncblock2/ShmName.h"
#include "hmibase/util/SyncObject.hpp"

namespace hmibase {
namespace gadget {
namespace syncblock2 {

class ShmProducerInst : public ProducerInst
{
   public:
      ShmProducerInst(int key, int instanceId);
      virtual ~ShmProducerInst();

      // Implement abstracts
      virtual void startTermination();
      virtual bool isTerminated();
      virtual int  exchange();
      virtual bool onRun(const bool& keepRunning);

   private:
      ShmName                  mShmName;
      SyncObject<BufferStatus> mSyncObject;
};


} // namespace
} // namespace
} // namespace

#endif
