/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/syncblock2/ShmProducerInst.h"
#include <unistd.h>

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#include "trcGenProj/Header/ShmProducerInst.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

namespace hmibase {
namespace gadget {
namespace syncblock2 {

ShmProducerInst::ShmProducerInst(int key, int instanceId)
   : ProducerInst(key, instanceId, SHM_PRODUCER)
   , mShmName(key, instanceId)
   , mSyncObject(mShmName.getName().cPtr(), true)
{
}


ShmProducerInst::~ShmProducerInst()
{
   startTermination();
   while (!isTerminated())
   {
      usleep(10000); // 10 milliseconds
   }
   mThread.finish();
}


bool ShmProducerInst::onRun(const bool& /*keepRunning*/)
{
   // We do not need the Socket, so close the thread as soon as possible.
   return false;
}


void ShmProducerInst::startTermination()
{
   BufferStatus* bsPtr = mSyncObject.getPayloadPtr();
   if (bsPtr != NULL)
   {
      bsPtr->requestClose();
   }
}


bool ShmProducerInst::isTerminated()
{
   BufferStatus* bsPtr = mSyncObject.getPayloadPtr();
   if (bsPtr != NULL)
   {
      return bsPtr->confirmClose();
   }

   return true;
}


int ShmProducerInst::exchange()
{
   mIsFirstExchange = false;
   BufferStatus* bsPtr = mSyncObject.getPayloadPtr();
   if (bsPtr != NULL)
   {
      int index = bsPtr->getNextWriteIndex();
      return getFd(index);
   }

   return -1;
}


} // namespace
} // namespace
} // namespace
