/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_SYNCBLOCK2_PRODUCERINST_H
#define HMIBASE_GADGET_SYNCBLOCK2_PRODUCERINST_H

#include "hmibase/gadget/syncblock2/BufferInfo.h"
#include "hmibase/gadget/syncblock2/ProducerType.h"
#include "hmibase/gadget/syncblock2/socks/Socket.h"
#include "hmibase/util/SimpleThread.h"
#include "hmibase/util/Threadable.h"

namespace hmibase {
namespace gadget {
namespace syncblock2 {

class ProducerInst : public hmibase::util::Threadable
{
   public:
      ProducerInst(int key, int instanceId, ProducerType producerType);
      virtual ~ProducerInst();

      void setBufferInfo(const BufferInfo& bufferInfo);
      const BufferInfo& getBufferInfo() const;

      void setFd(int index, int fd);
      int  getFd(int index) const;

      // Derived Classes must implement these
      virtual void startTermination() = 0;
      virtual bool isTerminated() = 0;
      virtual int  exchange() = 0;
      virtual bool onRun(const bool& keepRunning) = 0;

      // Threadable implementation
      virtual void onStart(const bool& keepRunning);
      virtual void onFinish(const bool& keepRunning);

      bool isFirstExchange() const;

   protected:
      int  mKey;
      int  mInstanceId;
      int  mFds[3];
      ProducerType mProducerType;
      bool mIsBufferInfoSet;
      bool mIsFirstExchange;
      BufferInfo mBufferInfo;
      hmibase::util::SimpleThread mThread;
      socks::Socket mSocket;

      bool isInitialized() const;

      // ObjectId is used for logging, do differentiate between objects
      static int smObjectCounter;
      int mObjectId;
};


} // namespace
} // namespace
} // namespace

#endif
