/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/syncblock2/ProducerInst.h"
#include "hmibase/gadget/syncblock2/socks/Socket.h"
#include "hmibase/gadget/syncblock2/socks/HelloMessage.h"
#include "hmibase/util/SimpleString.h"
#include <unistd.h>

#include "hmibase/util/Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW
#include "trcGenProj/Header/ProducerInst.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

using namespace hmibase::util;
using namespace hmibase::gadget::syncblock2::socks;

namespace hmibase {
namespace gadget {
namespace syncblock2 {

int ProducerInst::smObjectCounter = 0;

ProducerInst::ProducerInst(int key, int instanceId, ProducerType producerType)
   : mKey(key)
   , mInstanceId(instanceId)
   , mProducerType(producerType)
   , mIsBufferInfoSet(false)
   , mIsFirstExchange(true)
   , mBufferInfo()
   , mThread(*this, SS::format("Prod_%d_%d", mKey, mInstanceId).cPtr())
   , mSocket()
   , mObjectId(0)
{
   smObjectCounter++;
   mObjectId = smObjectCounter;

   mFds[0] = -1;
   mFds[1] = -1;
   mFds[2] = -1;

   mThread.start();
   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Constructor", mKey, mInstanceId, mObjectId));
}


ProducerInst::~ProducerInst()
{
// mThread.finish() has to be called in derived class.
   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Destructor", mKey, mInstanceId, mObjectId));
}


void ProducerInst::onStart(const bool& keepRunning)
{
   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Starting...", mKey, mInstanceId, mObjectId));
   if (!keepRunning)
   {
      return;
   }

   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Waiting to be initialized...", mKey, mInstanceId, mObjectId));
   while (!isInitialized())
   {
      if (!keepRunning)
      {
         return;
      }
      usleep(100000); // 100 Milliseconds
   }
   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Initialized.", mKey, mInstanceId, mObjectId));

   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Trying to Connect to Consumer.", mKey, mInstanceId, mObjectId));
   while (!mSocket.tryConnect(mKey))
   {
      if (!keepRunning)
      {
         return;
      }
      usleep(10000); // 10 Milliseconds
   }
   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Connected to Consumer.", mKey, mInstanceId, mObjectId));

   HelloMessage message;
   message.setInstanceId(mInstanceId);
   message.setProducerType(mProducerType);
   message.setFd(0, mFds[0]);
   message.setFd(1, mFds[1]);
   message.setFd(2, mFds[2]);
   message.setBufferInfo(mBufferInfo);

   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Sending HelloMessage (fd0=%d, fd1=%d, fd2=%d, type=%d, size=%d) to Consumer...", mKey, mInstanceId, mObjectId, mFds[0], mFds[1], mFds[2], (int)mProducerType, mBufferInfo.getSize()));
   while (!mSocket.send(message))
   {
      if (!keepRunning)
      {
         return;
      }
      usleep(10000); // 10 Milliseconds
   }
   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Sent HelloMessage to Consumer.", mKey, mInstanceId, mObjectId));
}


void ProducerInst::onFinish(const bool& /*keepRunning*/)
{
   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Closing Socket.", mKey, mInstanceId, mObjectId));
   mSocket.close();
   ETG_TRACE_USR4_THR(("Producer-Thread[%d][%d][%d]: Done.", mKey, mInstanceId, mObjectId));
}


bool ProducerInst::isFirstExchange() const
{
   return mIsFirstExchange;
}


bool ProducerInst::isInitialized() const
{
   if (!mIsBufferInfoSet)
   {
      return false;
   }

   for (int i = 0; i < 3; i++)
   {
      if (mFds[i] == -1)
      {
         return false;
      }
   }

   return true;
}


void ProducerInst::setBufferInfo(const BufferInfo& bufferInfo)
{
   mBufferInfo      = bufferInfo;
   mIsBufferInfoSet = true;
}


const BufferInfo& ProducerInst::getBufferInfo() const
{
   return mBufferInfo;
}


void ProducerInst::setFd(int index, int fd)
{
   if (index < 0 || index > 2)
   {
      return;
   }

   mFds[index] = fd;
}


int ProducerInst::getFd(int index) const
{
   if (index < 0 || index > 2)
   {
      return -1;
   }

   return mFds[index];
}


} // namespace
} // namespace
} // namespace
