/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#ifndef HMIBASE_GADGET_SYNCBLOCK2_CONSUMERINST_H
#define HMIBASE_GADGET_SYNCBLOCK2_CONSUMERINST_H

#include "hmibase/gadget/syncblock2/BufferInfo.h"

namespace hmibase {
namespace gadget {
namespace syncblock2 {

class ConsumerInst
{
   public:
      ConsumerInst(int key, int instanceId, int fd0, int fd1, int fd2, const BufferInfo& bufferInfo);
      virtual ~ConsumerInst();

      const BufferInfo& getBufferInfo() const;

      virtual int  exchange() = 0;
      virtual bool isUpdated() = 0;
      virtual void clearUpdatedFlag() = 0;
      virtual bool isTerminated() = 0;

   protected:
      int  mKey;
      int  mInstanceId;
      int  mFds[3];
      BufferInfo mBufferInfo;

      // ObjectId is used for logging, do differentiate between objects
      static int smObjectCounter;
      int mObjectId;
};


} // namespace
} // namespace
} // namespace

#endif
