/******************************************************************
*COPYRIGHT: (C) 2017 Robert Bosch GmbH
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/
#include "hmibase/gadget/syncblock2/BufferInfo.h"

namespace hmibase {
namespace gadget {
namespace syncblock2 {

BufferInfo::BufferInfo()
   : mSize(0)
   , mWidth(0)
   , mHeight(0)
   , mDepth(0)
   , mBpp(0)
   , mPitch(0)
{
}


BufferInfo::BufferInfo(const BufferInfo& right)
   : mSize(right.mSize)
   , mWidth(right.mWidth)
   , mHeight(right.mHeight)
   , mDepth(right.mDepth)
   , mBpp(right.mBpp)
   , mPitch(right.mPitch)
{
}


BufferInfo::BufferInfo(uint32_t size, uint16_t width, uint16_t height, uint16_t depth, uint16_t bpp, uint32_t pitch)
   : mSize(size)
   , mWidth(width)
   , mHeight(height)
   , mDepth(depth)
   , mBpp(bpp)
   , mPitch(pitch)
{
}


BufferInfo::~BufferInfo()
{
}


bool BufferInfo::operator==(const BufferInfo& right) const
{
   if (this == &right)
   {
      return true;
   }

   if (mSize != right.mSize)
   {
      return false;
   }

   if (mWidth != right.mWidth)
   {
      return false;
   }

   if (mHeight != right.mHeight)
   {
      return false;
   }

   if (mDepth != right.mDepth)
   {
      return false;
   }

   if (mBpp != right.mBpp)
   {
      return false;
   }

   if (mPitch != right.mPitch)
   {
      return false;
   }

   return true;
}


bool BufferInfo::operator!=(const BufferInfo& right) const
{
   return !(*this == right);
}


BufferInfo& BufferInfo::operator=(const BufferInfo& right)
{
   if (this != &right)
   {
      mSize   = right.mSize;
      mWidth  = right.mWidth;
      mHeight = right.mHeight;
      mDepth  = right.mDepth;
      mBpp    = right.mBpp;
      mPitch  = right.mPitch;
   }
   return *this;
}


uint32_t BufferInfo::getSize() const
{
   return mSize;
}


uint16_t BufferInfo::getWidth() const
{
   return mWidth;
}


uint16_t BufferInfo::getHeight() const
{
   return mHeight;
}


uint16_t BufferInfo::getDepth() const
{
   return mDepth;
}


uint16_t BufferInfo::getBpp() const
{
   return mBpp;
}


uint32_t BufferInfo::getPitch() const
{
   return mPitch;
}


} // namespace
} // namespace
} // namespace
