/* ***************************************************************************************
* FILE:          WaylandEventHook.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  WaylandEventHook.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(Shared_WaylandEventHook_h)
#define Shared_WaylandEventHook_h

#include <ScreenBroker/ScreenBroker.h>
#include <Shared/WaylandInc.h>

namespace ScreenBroker {
class WaylandContext;

/**
 * The class WaylandEventHook can be used to implement the reaction of
 * occurring wayland input events (currently key events only). To achieve
 * this derive from this base class and apply the proper input event
 * handling to the events needed.
 */
class WaylandEventHook
{
   public:
      ///
      WaylandEventHook() {}

      ///
      virtual ~WaylandEventHook() {}

      /// For detailed interface description see Wayland client protocol documentation (wl_keyboard_listener)
      virtual void OnKeyboardEventKeymap(WaylandContext* context,
                                         struct wl_keyboard* keyboard,
                                         uint32_t format,
                                         int32_t fd,
                                         uint32_t size)
      {
         (void) context;
         (void) keyboard;
         (void) format;
         (void) fd;
         (void) size;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_keyboard_listener)
      virtual void OnKeyboardEventEnter(WaylandContext* context,
                                        struct wl_keyboard* keyboard,
                                        uint32_t serial,
                                        struct wl_surface* surface,
                                        struct wl_array* keys)
      {
         (void) context;
         (void) keyboard;
         (void) serial;
         (void) surface;
         (void) keys;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_keyboard_listener)
      virtual void OnKeyboardEventLeave(WaylandContext* context,
                                        struct wl_keyboard* keyboard,
                                        uint32_t serial,
                                        struct wl_surface* surface)
      {
         (void) context;
         (void) keyboard;
         (void) serial;
         (void) surface;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_keyboard_listener)
      virtual void OnKeyboardEventKey(WaylandContext* context,
                                      struct wl_keyboard* keyboard,
                                      uint32_t serial,
                                      uint32_t time,
                                      uint32_t key,
                                      uint32_t state)
      {
         (void) context;
         (void) keyboard;
         (void) serial;
         (void) time;
         (void) key;
         (void) state;
      }

      /// For detailed interface description see Wayland client protocol documentation (wl_keyboard_listener)
      virtual void OnKeyboardEventModifiers(WaylandContext* context,
                                            struct wl_keyboard* keyboard,
                                            uint32_t serial,
                                            uint32_t mods_depressed,
                                            uint32_t mods_latched,
                                            uint32_t mods_locked,
                                            uint32_t group)
      {
         (void) context;
         (void) keyboard;
         (void) serial;
         (void) mods_depressed;
         (void) mods_latched;
         (void) mods_locked;
         (void) group;
      }
};


}

#endif
