/* ***************************************************************************************
* FILE:          FocusList.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FocusList.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBrokerPlugins_Shared_FocusList_h)
#define ScreenBrokerPlugins_Shared_FocusList_h

#include <ScreenBroker/ScreenBroker.h>
#include <ScreenBroker/Plugin/IScreenBrokerPlugin.h>
#include <list>
#include <map>

namespace ScreenBroker {
class FocusList
{
   public:
      FocusList() {}

      UInt32 SetFocus(UInt32 surfaceId);
      UInt32 GetFocus() const;

      UInt32 GetFirst();
      UInt32 GetNext();

      UInt32 Remove(UInt32 surfaceId);
      void PushBack(UInt32 surfaceId);

      UInt32 Size() const;
      void Reset();

      void Dump() const;
   private:
      typedef std::list<UInt32> SurfaceList;

      SurfaceList mFocusList;
      SurfaceList::const_iterator mIt;
};


}

#endif
