/* ***************************************************************************************
* FILE:          SimpleAnimation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimpleAnimation.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

// =============================================================================
// intented hiding of base class member
//lint -esym(1516, *::Base) "Member declaration hides inherited member"
// =============================================================================

#if !defined(ScreenBrokerPlugins_Shared_Animation_SimpleAnimation_h)
#define ScreenBrokerPlugins_Shared_Animation_SimpleAnimation_h

#include <Shared/Animation/Animation.h>
#include <Shared/Animation/AnimationProperties.h>
#include <Shared/Animation/Rectangle.h>

namespace ScreenBroker {
///
class SimpleAnimation : public AnimationBase
{
   public:
      ///
      SimpleAnimation();

      ///
      virtual ~SimpleAnimation();

      ///
      virtual bool Start();

      ///
      virtual void Cancel();

      ///
      void SetSurfaceId(UInt32 surfaceId);

      ///
      void StartSimpleAnimation(bool commit = true);

      ///
      virtual UInt32 GetSurfaceId();

      ///
      void SetLayerId(UInt32 surfaceId);

      ///
      virtual UInt32 GetLayerId();
      ///
      void SetAnimationDirection(AnimationDirection::Enum animationDirection);

      ///
      void SetAnimationUserData(const AnimationUserData& animationUserData);

      ///
      void SetInitialSurfaceBounds(const Rectangle& initialSurfaceBounds);

      ///
      virtual void Reset();

   private:
      UInt32 mSurfaceId;
      UInt32 mLayerId;
      AnimationDirection::Enum mAnimationDirection;
      AnimationUserData mAnimationUserData;
      Rectangle mInitialSurfaceBounds;

      bool mStarted;
};


}

#endif
