/* ***************************************************************************************
* FILE:          ScaleAndFadeAnimation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ScaleAndFadeAnimation.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

// =============================================================================
// intented hiding of base class member
//lint -esym(1516, *::Base) "Member declaration hides inherited member"
// =============================================================================

#if !defined(ScreenBrokerPlugins_Shared_Animation_ScaleAndFadeAnimation_h)
#define ScreenBrokerPlugins_Shared_Animation_ScaleAndFadeAnimation_h

#include <Shared/Animation/Animation.h>
#include <Shared/Animation/Rectangle.h>

namespace ScreenBroker {
typedef AnimationSurfaceProperties<Rectangle> ScaleAndFadeAnimationSurfaceProperties;

///
class ScaleAndFadeAnimation : public Animation<ScaleAndFadeAnimationSurfaceProperties>
{
      typedef Animation<ScaleAndFadeAnimationSurfaceProperties> Base;
      float initialOpacity;
      float finalOpacity;
   public:
      ScaleAndFadeAnimation() : Base()
      {
         initialOpacity = 0.0;
         finalOpacity = 1.0;
      }
      void SetOpacityDetails(float start, float end);
   protected:
      virtual bool InitializeSurfaceState(ScaleAndFadeAnimationSurfaceProperties& surfaceProperties, bool commit);
      virtual bool UpdateSurfaceState(const ScaleAndFadeAnimationSurfaceProperties& surfaceProperties,
                                      UInt32 count,
                                      bool commit);
      virtual bool SetFinalSurfaceState(const ScaleAndFadeAnimationSurfaceProperties& surfaceProperties, bool commit);
      void GetFadeAnimationDetails(float& start, float& end);
};


}

#endif
