/* ***************************************************************************************
* FILE:          Rectangle.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Rectangle.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(ScreenBrokerPlugins_Shared_Util_Rectangle_h)
#define ScreenBrokerPlugins_Shared_Util_Rectangle_h

#include <ScreenBroker/Types.h>
#include <Shared/Animation/Position.h>

namespace ScreenBroker {

///
/// \brief The Rectangle class
///
class Rectangle
{
   public:
      Position position;
      Int32 width;
      Int32 height;

      Rectangle() :
         position(0, 0),
         width(0),
         height(0)
      {}

      Rectangle(Int32 posX, Int32 posY, Int32 width, Int32 height) :
         position(posX, posY),
         width(width),
         height(height)
      {}
};


}

#endif
