/* ***************************************************************************************
* FILE:          QuadEaseInterpolationStrategy.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  QuadEaseInterpolationStrategy.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(ScreenBrokerPlugins_Shared_Interpolation_QuadEaseInterpolationStrategy_h)
#define ScreenBrokerPlugins_Shared_Interpolation_QuadEaseInterpolationStrategy_h

#include <Shared/Animation/EaseInterpolationStrategy.h>

namespace ScreenBroker {
class QuadEaseInterpolationStrategy : public EaseInterpolationStrategy
{
   protected:
      virtual Float EaseIn(Float t, Float b, Float c, Float d);
      virtual Float EaseOut(Float t, Float b, Float c, Float d);
      virtual Float EaseInOut(Float t, Float b, Float c, Float d);
};


}

#endif
