/* ***************************************************************************************
* FILE:          LinearInterpolationStrategy.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  LinearInterpolationStrategy.cpp is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "LinearInterpolationStrategy.h"

namespace ScreenBroker {

// ------------------------------------------------------------------------
Float LinearInterpolationStrategy::Interpolate(UInt32 steps, Float start, Float end, UInt32 count)
{
   return (0 != steps) ? (((end - start) / Float(steps)) * float(count)) : 0.0F;
}


}
