/* ***************************************************************************************
* FILE:          InterpolationPool.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  InterpolationPool.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

// =============================================================================
// Exposing this private object is intended
//lint -efunc(1536, *::GetInterpolation) "Exposing low access member"
// =============================================================================

#if !defined(ScreenBrokerPlugins_Shared_Interpolation_InterpolationPool_h)
#define ScreenBrokerPlugins_Shared_Interpolation_InterpolationPool_h

#include <ScreenBroker/Types.h>
#include <Shared/Animation/InterpolationStrategy.h>
#include <Shared/Animation/InterpolationPoolBase.h>

namespace ScreenBroker {

///
template <typename TInterpolation, UInt8 Capacity>
class InterpolationPool : public InterpolationPoolBase
{
   public:

      static InterpolationPool& GetInstance();

      virtual InterpolationStrategy* GetInterpolation();
      virtual void ReturnInterpolation(InterpolationStrategy* interpolation);

   private:
      TInterpolation mInterpolations[Capacity];
      bool mActivityFlags[Capacity];
};


// ------------------------------------------------------------------------
template <typename TInterpolation, UInt8 Capacity>
InterpolationPool<TInterpolation, Capacity>& InterpolationPool<TInterpolation, Capacity>::GetInstance()
{
   static InterpolationPool lInterpolationPool;
   return lInterpolationPool;
}


// ------------------------------------------------------------------------
template <typename TInterpolation, UInt8 Capacity>
InterpolationStrategy* InterpolationPool<TInterpolation, Capacity>::GetInterpolation()
{
   for (UInt8 i = 0; i < Capacity; i++)
   {
      if (!mActivityFlags[i])
      {
         mActivityFlags[i] = true;
         mInterpolations[i].Reset();
         mInterpolations[i].SetPool(this);
         return &mInterpolations[i];
      }
   }
   return 0;
}


// ------------------------------------------------------------------------
template <typename TInterpolation, UInt8 Capacity>
void InterpolationPool<TInterpolation, Capacity>::ReturnInterpolation(InterpolationStrategy* interpolation)
{
   for (UInt8 i = 0; i < Capacity; i++)
   {
      if (interpolation == &mInterpolations[i])
      {
         mActivityFlags[i] = false;
         break;
      }
   }
}


}

#endif
