/* ***************************************************************************************
* FILE:          FadingAnimation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FadingAnimation.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

// =============================================================================
// intented hiding of base class member
//lint -esym(1516, *::Base) "Member declaration hides inherited member"
// =============================================================================

#if !defined(ScreenBrokerPlugins_Shared_Animation_FadingAnimation_h)
#define ScreenBrokerPlugins_Shared_Animation_FadingAnimation_h

#include <Shared/Animation/Animation.h>

namespace ScreenBroker {
typedef AnimationSurfaceProperties<Float> FadingAnimationSurfaceProperties;

///
class FadingAnimation : public Animation<FadingAnimationSurfaceProperties>
{
      typedef Animation<FadingAnimationSurfaceProperties> Base;

   public:
      FadingAnimation() : Base() {}

   protected:
      virtual bool InitializeSurfaceState(FadingAnimationSurfaceProperties& surfaceProperties, bool commit);
      virtual bool UpdateSurfaceState(const FadingAnimationSurfaceProperties& surfaceProperties, UInt32 count, bool commit);
      virtual bool SetFinalSurfaceState(const FadingAnimationSurfaceProperties& surfaceProperties, bool commit);
};


}

#endif
