/* ***************************************************************************************
* FILE:          AnimationProperties.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationProperties.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBrokerPlugins_Shared_Animation_AnimationProperties_h)
#define ScreenBrokerPlugins_Shared_Animation_AnimationProperties_h

#include <Base.h>
#include <Shared/Animation/AnimationType.h>
#include <Shared/Animation/AccelerationType.h>

namespace ScreenBroker {
///
namespace AnimationDirection {
enum Enum
{
   Undefined,
   Show,
   Hide,
   Custom,
   End
};


}

//To be update with proper details
namespace PivotPoint {
enum Enum
{
   Undefined,
   Center,
   TopLeft,
   TopRight,
   BottomLeft,
   BottomRight,
   Top,
   Bottom,
   Left,
   Right,
   End
};


}

///
struct AnimationProperties
{
   static const UInt32 cDefaultDuration = 1000;
   static const UInt32 cDefaultDelayDuration = 0;
   static const UInt32 cDefaultUpdateCount = 100;
   static const AccelerationType::Enum cDefaultAccelerationType = AccelerationType::Linear;
#if __cplusplus >= 201103L
   static constexpr Float cDefaultAmplitude = 1.0F;
#else
   static const Float cDefaultAmplitude = 1.0F;
#endif
   static const UInt32 cScaleFrom = 99;
   static const UInt32 cScaleTo = 99;

   //static const UInt32 cPivotX = 400;
   //static const UInt32 cPivotY = 240;

   AnimationType::Enum type;
   UInt32 duration;
   UInt32 delayduration;
   UInt32 steps;
   AccelerationType::Enum acceleration;
   Float amplitude;
   UInt32 scaleFrom;
   UInt32 scaleTo;
   PivotPoint::Enum pivotPoint;

   AnimationProperties() :
      type(AnimationType::None),
      duration(0U),
      delayduration(0U),
      steps(0U),
      acceleration(AccelerationType::Linear),
      amplitude(1.0F),
      scaleFrom(cScaleFrom),
      scaleTo(cScaleTo),
      pivotPoint(PivotPoint::Undefined)
   {}

   AnimationProperties(AnimationType::Enum aType,
                       UInt32 aDuration,
                       UInt32 aDelayDuration,
                       UInt32 aSteps,
                       AccelerationType::Enum aAcceleration,
                       Float aAmplitude,
                       UInt32 aScaleFrom,
                       UInt32 aScaleTo,
                       PivotPoint::Enum aPivotPoint) :
      type(aType),
      duration(aDuration),
      delayduration(aDelayDuration),
      steps(aSteps),
      acceleration(aAcceleration),
      amplitude(aAmplitude),
      scaleFrom(aScaleFrom),
      scaleTo(aScaleTo),
      pivotPoint(aPivotPoint)
   {}
};


}

#endif
