/* ***************************************************************************************
* FILE:          AnimationPool.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationPool.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

// =============================================================================
// Exposing this private object is intended
//lint -efunc(1536, *::GetAnimation) "Exposing low access member"
// =============================================================================

#if !defined(ScreenBrokerPlugins_Shared_Animation_AnimationPool_h)
#define ScreenBrokerPlugins_Shared_Animation_AnimationPool_h

#include <ScreenBroker/Types.h>
#include <Shared/Animation/AnimationBase.h>
#include <Shared/Animation/AnimationPoolBase.h>

namespace ScreenBroker {

///
template <typename TAnimation, UInt8 Capacity>
class AnimationPool : public AnimationPoolBase
{
   public:

      static AnimationPool& GetInstance();

      virtual AnimationBase* GetAnimation();
      virtual void ReturnAnimation(AnimationBase* animation);

   private:
      TAnimation mAnimations[Capacity];
      bool mActivityFlags[Capacity];
};


// ------------------------------------------------------------------------
template <typename TAnimation, UInt8 Capacity>
AnimationPool<TAnimation, Capacity>& AnimationPool<TAnimation, Capacity>::GetInstance()
{
   static AnimationPool lAnimationPool;
   return lAnimationPool;
}


// ------------------------------------------------------------------------
template <typename TAnimation, UInt8 Capacity>
AnimationBase* AnimationPool<TAnimation, Capacity>::GetAnimation()
{
   for (UInt8 i = 0; i < Capacity; i++)
   {
      if (!mActivityFlags[i])
      {
         mActivityFlags[i] = true;
         mAnimations[i].Reset();
         mAnimations[i].SetPool(this);
         return &mAnimations[i];
      }
   }
   return 0;
}


// ------------------------------------------------------------------------
template <typename TAnimation, UInt8 Capacity>
void AnimationPool<TAnimation, Capacity>::ReturnAnimation(AnimationBase* animation)
{
   for (UInt8 i = 0; i < Capacity; i++)
   {
      if (animation == &mAnimations[i])
      {
         mActivityFlags[i] = false;
         break;
      }
   }
}


}

#endif
