/* ***************************************************************************************
* FILE:          AnimationFactory.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationFactory.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBrokerPlugins_Shared_Animation_AnimationFactory_h)
#define ScreenBrokerPlugins_Shared_Animation_AnimationFactory_h

#include <Base.h>
#include <Shared/Animation/AnimationType.h>
#include <Shared/Animation/Rectangle.h>
#include <Shared/Animation/AnimationProperties.h>
#include <map>

namespace ScreenBroker {

class AnimationBase;
class AnimationSurfacePropertiesBase;
struct AnimationUserData;

class AnimationFactory
{
   public:
      static const UInt32 cMaxParallelZoomAnimations = 10;
      static const UInt32 cMaxParallelZoomAndFadeAnimations = 10;
      static const UInt32 cMaxParallelFadeAnimations = 10;
      static const UInt32 cMaxParallelSlidingAnimations = 10;
      static const UInt32 cMaxParallelSimpleAnimations = 10;

      static AnimationBase* CreateAnimation(AnimationType::Enum animationType,
                                            UInt32 surfaceId,
                                            const AnimationUserData& animationUserData,
                                            AnimationDirection::Enum animationDirection,
                                            bool isLayerContent = false);

   private:
      typedef std::map<UInt32, Rectangle> SurfaceBoundsMap;
      typedef SurfaceBoundsMap::iterator SurfaceBoundsMapIterator;

      static SurfaceBoundsMap mInitialSurfaceBounds;
      typedef std::map<UInt32, Rectangle> LayerBoundsMap;
      typedef SurfaceBoundsMap::iterator LayerBoundsMapIterator;

      static SurfaceBoundsMap mInitialLayerBounds;

      static AnimationBase* CreateFadeInAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateFadeOutAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomInFromTopLeftAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomOutToTopLeftAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateSlideInFromLeftAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateSlideOutToLeftAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateSlideInFromTopAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateSlideOutToTopAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateSlideInFromRightAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateSlideOutToRightAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateSlideInFromBottomAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateSlideOutToBottomAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomInFromTopRightAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomOutToTopRightAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomInFromBottomLeftAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomOutToBottomLeftAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomInFromBottomRightAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomOutToBottomRightAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateShowImmediatelyAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, bool isLayerContent = false);
      static AnimationBase* CreateHideImmediatelyAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, bool isLayerContent = false);
      static AnimationBase* CreateZoomInFromCenterAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomOutToCenterAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomInFadeInAnimation(UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);
      static AnimationBase* CreateZoomPlusFadeAnimation(AnimationType::Enum animationType, UInt32 surfaceId, const AnimationUserData& animationUserData, AnimationDirection::Enum animationDirection, bool isLayerContent = false);

      static void OnBeforeAnimation(const AnimationSurfacePropertiesBase& surfaceProperties);
      static void OnBeforeCustomAnimation(const AnimationSurfacePropertiesBase& surfaceProperties);

      static bool GetInitialSurfaceBounds(UInt32 surfaceId, Rectangle& bounds);
      static bool GetInitialLayerBounds(UInt32 layerId, Rectangle& bounds);
      static bool InitializeSurfaceState(UInt32 surfaceId);
      static bool InitializeLayerState(UInt32 layerId);
      static void DeterminePosXAndWidth(UInt32 surfaceId, Int32& posX, UInt32& width, UInt32 scale, Int32 pivotX);
      static void DeterminePosYAndHeight(UInt32 surfaceId, Int32& posY, UInt32& height, UInt32 scale, Int32 pivotY);
};


}

#endif
