/* ***************************************************************************************
* FILE:          AnimationBase.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AnimationBase.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include <ScreenBroker/Types.h>
#include <Shared/Animation/AnimationProperties.h>
#include <list>
#if !defined(ScreenBrokerPlugins_Shared_Animation_AnimationBase_h)
#define ScreenBrokerPlugins_Shared_Animation_AnimationBase_h

namespace ScreenBroker {

class AnimationPoolBase;

///
class AnimationBase
{
   public:
      AnimationBase() : mPool(0), mAnimationInProgress(false), mIsSequentialAnimation(false), isLayerContent(false) { }
      virtual ~AnimationBase()
      {
      }

      virtual bool Start() = 0;
      virtual void Cancel() = 0;
      virtual void Reset() = 0;

      virtual UInt32 GetSurfaceId() = 0;

      void SetPool(AnimationPoolBase* pool)
      {
         mPool = pool;
      }

      void SetAnimationStatus(bool status)
      {
         mAnimationInProgress = status;
      }

      bool GetAnimationStatus()
      {
         return mAnimationInProgress;
      }

      void UpdateAnimationCategory(bool category)
      {
         mIsSequentialAnimation = category;
      }
      bool GetAnimationCategory()
      {
         return mIsSequentialAnimation;
      }
      bool GetContentType()
      {
         return isLayerContent;
      }
      void setContentType(bool isLayer)
      {
         isLayerContent = isLayer;
      }
   protected:
      AnimationPoolBase* mPool;
      bool mAnimationInProgress;
      bool mIsSequentialAnimation;
      bool isLayerContent;
};


}

#endif
