/* ***************************************************************************************
* FILE:          PopupManagerActivator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PopupManagerActivator.h is part of HMI-Base ScreenBrokerPlugins
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

// =============================================================================
//lint -esym(1511, ScreenBroker::IScreenBrokerPlugin::Create) "static member can't be made virtual"
// This class is intended to be a singleton, for this reason it is ok, that the
// constructor has only private access.
//lint -esym(1704, ScreenBroker::PopupManagerActivator::PopupManagerActivator)
//"Constructor has private access specification"
// =============================================================================

#if !defined(ScreenBrokerPlugins_PopupManagerActivator_PopupManagerActivator_h)
#define ScreenBrokerPlugins_PopupManagerActivator_PopupManagerActivator_h

#include <ScreenBroker/Plugin/IPopupManagerActivator.h>
#include <ilm/ilm_types.h>

namespace ScreenBroker {
class ActiveSurfaces;

///
class PopupManagerActivator : public IPopupManagerActivator
{
   public:
      ///
      static IScreenBrokerPlugin& Create();

      ///
      virtual ~PopupManagerActivator();

      ///
      virtual bool Init();

      ///
      virtual void Reset();

      ///
      virtual void Diagnosis();

      ///
      virtual void Test();

      ///
      virtual void ShowPopup(const ServiceRequestArg& serviceRequestArg,
                             PopupState& popupState,
                             UInt32 hint);

      ///
      virtual void HidePopup(const ServiceRequestArg& serviceRequestArg,
                             PopupState& popupState);

      ///
      virtual void CloseOnExternalTouch(const ServiceRequestArg& ServiceRequestArg);

      ///
      virtual void UpdatePopup(PopupState& popupState);

      ///
      virtual void SetPopupFilter(const ServiceRequestArg& serviceRequestArg,
                                  bool disableAll,
                                  const PopupPresentationArg& popupPresentationArg);

      ///
      virtual void ClearPopupFilter(const ServiceRequestArg& serviceRequestArg);

      ///
      virtual void Action(UInt32 actionId, UInt32 actionData);

      ///
      virtual void RequestCurrentStatus(UInt32 requestId);

      ///
      virtual void SetInputFocus(UInt32 surfaceId,
                                 bool keyboardFocus,
                                 bool pointerFocus,
                                 Int32 priority,
                                 UInt32 focusData);

      ///
      virtual void DeregisterSurface(UInt32 surfaceId);

   private:
      ///
      PopupManagerActivator();

      ///
      static void DumpPopupList(UInt32 popupScreenAreaId);

      ///
      static void DumpPopupList();

      ///
      static UInt32 PriorityInsert(PopupState& popupState);

      ///
      static bool CloseOnSuperseded(PopupState*& supersededPopupState,
                                    const PopupState* topPopupState);
};


}

#endif
