/* ***************************************************************************************
* FILE:          Time.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Time.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_Util_Time_h)
#define ScreenBroker_Util_Time_h

#include <ScreenBroker/ScreenBroker.h>

namespace ScreenBroker {
/// @addtogroup ScreenBrokerUtil
/// @{

/**
 * @brief Some time handling utlility functions.
 */
class Time
{
   public:
      /**
       * @brief Returns the clock type on which time calculations of screen broker are based on.
       *
       * This clock type can be changed by setting the compile flag SCREENBROKER_CLOCKTYPE to the
       * clock type to use. Default clock type is CLOCK_MONOTONIC.
       *
       * @return Clock type used throughout screen broker.
       */
      static Int ClockType();

      /**
       * @brief Returns the current system time having the time based on screen broker's clock type
       * (see ClockType()).
       *
       * @return Current system time.
       */
      static UInt64 Now();

      /**
       * @brief Calculates the time passed from given start time till now.
       *
       * @param startTime Previous time stamp based on the screen broker time base (see Now()).
       *
       * @return Time passed from given start time till now.
       */
      static UInt32 Passed(UInt64 startTime);
};


/// @}
}


#endif
