/* ***************************************************************************************
* FILE:          Time.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Time.cpp is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#include "Time.h"

#include <sys/time.h>
#include <sys/timerfd.h>
#include <stdio.h>
#include <errno.h>

#if !defined(SCREENBROKER_CLOCKTYPE)
#define SCREENBROKER_CLOCKTYPE CLOCK_MONOTONIC
#endif
#include "ScreenBroker/ScreenBroker_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SB_SCREENBROKER
#include "trcGenProj/Header/Time.cpp.trc.h"
#endif


namespace ScreenBroker {
// SCREENBROKER_LOG_SET_REALM(LogRealm::Utilities);

// ------------------------------------------------------------------------
Int Time::ClockType()
{
   return SCREENBROKER_CLOCKTYPE;
}


// ------------------------------------------------------------------------
UInt64 Time::Now()
{
   UInt64 lNow = 0;
   struct timespec lCurrentSystemTime;
   if (-1 != clock_gettime(ClockType(), &lCurrentSystemTime))
   {
      lNow = static_cast<unsigned>(static_cast<Int64>(lCurrentSystemTime.tv_sec)) * 1000ULL +
             static_cast<unsigned>(static_cast<Int64>(lCurrentSystemTime.tv_nsec)) / 1000000ULL;
   }
   else
   {
      ETG_TRACE_ERR(("Reading clock failed! errno=%d", errno));
   }
   return lNow;
}


// ------------------------------------------------------------------------
UInt32 Time::Passed(UInt64 startTime)
{
   UInt64 lNow = Now();
   return (0 != lNow) ? static_cast<UInt32>(lNow - startTime) : 0ul;
}


}
