/* ***************************************************************************************
* FILE:          Debug.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Debug.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_Util_Debug_h)
#define ScreenBroker_Util_Debug_h

#include <ScreenBroker/ScreenBroker.h>

namespace ScreenBroker {
/// @addtogroup ScreenBrokerUtil
/// @{

/**
 * @brief Some Debug utlility functions.
 */
class Debug
{
   public:
      /**
       * @brief Prints the current callstack to the log (with level WARN).
       * @param realm Log realm where the callstack shall be related to.
       * @param maxLevels Maximum number of function calls to be printed in the callstack.
       */
      //static void Callstack(SCREENBROKER_LOG_REALM_TYPE realm, UInt8 maxLevels = 8);
      static void Callstack(UInt8 maxLevels = 8);
};


#define SCREENBROKER_LOG_CALLSTACK(...)   \
        ScreenBroker::Debug::Callstack(SCREENBROKER_LOG_REALM, ## __VA_ARGS__)
/// @}
}


#endif
