/* ***************************************************************************************
* FILE:          CriticalSection.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CriticalSection.cpp is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


// =============================================================================
// The intention of this CriticalSection class is to provide separate interfaces
// for lock and unlock.
//lint -efunc(454, ScreenBroker::CriticalSection::Obtain)  "A thread mutex has been locked but not unlocked"
//lint -efunc(455, ScreenBroker::CriticalSection::Release) "A thread mutex that had not been locked is being unlocked"
// =============================================================================

#include "CriticalSection.h"
#include <errno.h>
#include "ScreenBroker/ScreenBroker_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SB_SCREENBROKER
#include "trcGenProj/Header/CriticalSection.cpp.trc.h"
#endif


namespace ScreenBroker {
// SCREENBROKER_LOG_SET_REALM(LogRealm::Utilities);

// -------------------------------------------------------------------------
CriticalSection::CriticalSection()
{
   pthread_mutexattr_t attr;
   bool lRc = (0 == pthread_mutexattr_init(&attr));
   if (lRc)
   {
      lRc = (0 == pthread_mutexattr_settype(&attr,
                                            PTHREAD_MUTEX_RECURSIVE));
      if (lRc)
      {
         lRc = (0 == pthread_mutex_init(&mMutex, &attr));
         (void) pthread_mutexattr_destroy(&attr);
      }
   }
   if (!lRc)
   {
      ETG_TRACE_ERR(("CriticalSection creation failed! errno=%d", errno));
   }
}


// -------------------------------------------------------------------------
CriticalSection::~CriticalSection()
{
   (void) pthread_mutex_destroy(&mMutex);
}


// -------------------------------------------------------------------------
void CriticalSection::Obtain()
{
   int lRc = pthread_mutex_lock(&mMutex);
   if (0 != lRc)
   {
      ETG_TRACE_ERR(("CriticalSection creation failed! errno=%d", errno));
   }
}


// -------------------------------------------------------------------------
void CriticalSection::Release()
{
   int lRc = pthread_mutex_unlock(&mMutex);
   if (0 != lRc)
   {
      ETG_TRACE_ERR(("CriticalSection creation failed! errno=%d", errno));
   }
}


// -------------------------------------------------------------------------
bool CriticalSection::Try()
{
   int lRc = pthread_mutex_trylock(&mMutex);
   if ((0 != lRc) && (EBUSY != lRc))
   {
      ETG_TRACE_ERR(("CriticalSection creation failed! errno=%d", errno));
   }
   return (0 == lRc);
}


}
