/* ***************************************************************************************
* FILE:          Synchronize.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Synchronize.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


// =============================================================================
// The intention of this class it to live only within a block scope. Furthermore
// it activates the resp. functionality with the constructor call and
// deactivates it at desctruction time.
//lint -esym(1788, ScreenBroker::Synchronize)   "Variable is referenced only by its constructor or destructor"
// This class is intended to be a not copyable, for this reason it is ok, that
// the copy constructor have only private access.
//lint -esym(1704, ScreenBroker::Synchronize::Synchronize)   "Constructor has private access specification"
// =============================================================================

#if !defined(ScreenBroker_Service_Synchronize_h)
#define ScreenBroker_Service_Synchronize_h

#include <ScreenBroker/Util/CriticalSection.h>

/// Just call "SCREENBROKER_SYNCHRONIZE();" in the scope being synchronized.
#define SCREENBROKER_SYNCHRONIZE() \
    ScreenBroker::Synchronize __lScreenBrokerSynchronizer__

namespace ScreenBroker {
/// @addtogroup ScreenBrokerService
/// @{

/**
 * @brief The Synchronize class encapsulates the obtaining and
 * releasing of the service synchronization critical section into an
 * object.
 *
 * Because the obtaining is done in the constructor and the releasing
 * in the destructor, it is assured that there is no obtain without its
 * corresponding release.
 */
class Synchronize : public CriticalSectionLocker
{
      typedef CriticalSectionLocker Base;
   public:
      /**
       * @brief Waits for the ownership of the critical section (ctor).
       *
       * The state of the critical section is signaled if no thread owns it.
       * The method returns when the calling thread is granted ownership.
       */
      Synchronize();

   private:
      Synchronize(const Synchronize& Synchronize);
      Synchronize& operator=(const Synchronize& Synchronize);
};


/// @}
}


#endif
