/* ***************************************************************************************
* FILE:          AsfServiceAdaptor.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  AsfServiceAdaptor.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef SBSERVICE_ASFSERVICEADAPTOR_H
#define SBSERVICE_ASFSERVICEADAPTOR_H


#include "bosch/cm/ai/hmi/screenbroker/ServiceStub.h"
#include <ScreenBroker/Service/ServiceAdaptor.h>
#include "bosch/cm/ai/hmi/screenbroker/Arguments.h"
#include "bosch/cm/ai/hmi/screenbroker/TypesConst.h"

namespace ScreenBroker {
namespace Internal {

class AsfServiceAdaptor : public bosch::cm::ai::hmi::screenbroker::Service::ServiceStub,
   public ServiceAdaptor


{
   public:
      static ServiceAdaptor* DoGetInstance();

      virtual const Char* GetServiceId() const;
      virtual bool Init();
      virtual void Run();
      virtual void Terminate();

      //featScreenbrokerServiceStub
      virtual void onClientTerminationRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ClientTerminationRequest >& request);
      virtual void onGetDisplayIdRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::GetDisplayIdRequest >& request);
      virtual void onGetPreferredDimensionsRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::GetPreferredDimensionsRequest >& request);
      virtual void onRegisterSurfaceRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::RegisterSurfaceRequest >& request);
      virtual void onDeregisterSurfaceRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::DeregisterSurfaceRequest >& request);
      virtual void onActivateApplicationRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ActivateApplicationRequest >& request);
      virtual void onStartAnimationRequest(const ::boost::shared_ptr<bosch::cm::ai::hmi::screenbroker::Service::StartAnimationRequest>& request);
      virtual void onAttachandAnimateLayerRequest(const ::boost::shared_ptr<bosch::cm::ai::hmi::screenbroker::Service::AttachandAnimateLayerRequest>& request);
      virtual void onShowPopupRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ShowPopupRequest >& request);
      virtual void onHidePopupRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::HidePopupRequest >& request);
      virtual void onCloseOnExternalTouchRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::CloseOnExternalTouchRequest >& request);
      virtual void onSetPopupFilterRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::SetPopupFilterRequest >& request);
      virtual void onClearPopupFilterRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ClearPopupFilterRequest >& request);
      virtual void onKeyFeedbackRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::KeyFeedbackRequest >& request);
      virtual void onActionRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ActionRequest >& request);
      virtual void onSetInputFocusRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::SetInputFocusRequest >& request);
      virtual void onRequestCurrentStatusRequest(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::RequestCurrentStatusRequest >& request);

      ///
      virtual void SendOnGetDisplayId(const std::string& clientId,
                                      const RequestArg& reqArg,
                                      UInt32 displayId);
      ///
      virtual void SendOnGetPreferredDimensions(const std::string& clientId,
            const RequestArg& reqArg,
            const DimensionArg& dimArg);
      ///
      virtual void SendNotifySurfaceStateChange(const std::string& clientId,
            UInt32 userData,
            UInt32 surfaceId,
            UInt32 displayId,
            UInt32 displayAlias,
            SurfaceState::Enum state);
      ///
      virtual void SendNotifyError(const ServiceRequestArg& serviceRequestArg,
                                   Int32 systemErrno,
                                   Int32 presentationErrno);
      ///
      virtual void SendNotifyKeyEvent(const std::string& clientId,
                                      UInt32 userData,
                                      UInt32 surfaceId,
                                      UInt32 keyCode,
                                      KeyState::Enum keyState);
      ///
      virtual void SendNotifyCurrentStatus(const std::string& clientId,
                                           UInt32 requestId,
                                           UInt32 surfaceId,
                                           UInt32 status,
                                           UInt32 userData);

      ///
      virtual void SendNotifyLayerStateChanged(const std::string& clientId,
            UInt32 requestId,
            UInt32 layerId,
            LayerState::Enum state);
      ///
      virtual void SendNotifyCloseOnExternalTouch(bool status);

      ///
      virtual void UpdateBuildInLayerInformation(UInt32 layerId, UInt32 surfaceId, UInt32 screenId, UInt32 width, UInt32 height, std::string connectorName = "");

   private:
      AsfServiceAdaptor();
      virtual ~AsfServiceAdaptor();
      AsfServiceAdaptor(const AsfServiceAdaptor&);                 // Prevent copy-construction
      AsfServiceAdaptor& operator=(const AsfServiceAdaptor&);      // Prevent assignment
};


} // namespace
} // namespace


#endif // SBSERVICE_ASFSERVICEADAPTOR
