/* ***************************************************************************************
* FILE:          PopupPresentationArg.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  PopupPresentationArg.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_PopupPresentationArg_h)
#define ScreenBroker_PopupPresentationArg_h

#include <ScreenBroker/ScreenBroker.h>
#include <ScreenBroker/HorizontalAlignment.h>
#include <ScreenBroker/Modality.h>
#include <ScreenBroker/Scaling.h>
#include <ScreenBroker/VerticalAlignment.h>

namespace ScreenBroker {
/// @addtogroup ScreenBrokerCommon
/// @{

/**
 * @brief The PopupPresentationArg struct serves as container for popup properties.
 */
struct PopupPresentationArg
{
      ///
      PopupPresentationArg()
         : mPriority(0),
           mModality(Modality::None),
           mPresentationTime(0),
           mMinimumPresentationTime(0),
           mValidityPeriod(0),
           mHorizontalAlignment(HorizontalAlignment::Center),
           mVerticalAlignment(VerticalAlignment::Center),
           mScaling(Scaling::None),
           mFocusPriority(0)
      {}

      ///
      PopupPresentationArg(UInt32 priority,
                           Modality::Enum modality,
                           UInt32 presentationTime,
                           UInt32 minimumPresentationTime,
                           UInt32 validityPeriod,
                           HorizontalAlignment::Enum horizontalAlignment,
                           VerticalAlignment::Enum verticalAlignment,
                           Scaling::Enum scaling,
                           Int32 focusPriority)
         : mPriority(priority),
           mModality(modality),
           mPresentationTime(presentationTime),
           mMinimumPresentationTime(minimumPresentationTime),
           mValidityPeriod(validityPeriod),
           mHorizontalAlignment(horizontalAlignment),
           mVerticalAlignment(verticalAlignment),
           mScaling(scaling),
           mFocusPriority(focusPriority)
      {}

      ///
      UInt32 Priority() const
      {
         return mPriority;
      }

      ///
      void SetPriority(UInt32 priority)
      {
         mPriority = priority;
      }

      ///
      Modality::Enum Modality() const
      {
         return mModality;
      }

      ///
      void SetModality(Modality::Enum modality)
      {
         mModality = modality;
      }

      ///
      UInt32 PresentationTime() const
      {
         return mPresentationTime;
      }

      ///
      void SetPresentationTime(UInt32 presentationTime)
      {
         mPresentationTime = presentationTime;
      }

      ///
      UInt32 MinimumPresentationTime() const
      {
         return mMinimumPresentationTime;
      }

      ///
      void SetMinimumPresentationTime(UInt32 minimumPresentationTime)
      {
         mMinimumPresentationTime = minimumPresentationTime;
      }

      ///
      UInt32 ValidityPeriod() const
      {
         return mValidityPeriod;
      }

      ///
      void SetValidityPeriod(UInt32 validityPeriod)
      {
         mValidityPeriod = validityPeriod;
      }

      ///
      HorizontalAlignment::Enum HorizontalAlignment() const
      {
         return mHorizontalAlignment;
      }

      ///
      void SetHorizontalAlignment(HorizontalAlignment::Enum horizontalAlignment)
      {
         mHorizontalAlignment = horizontalAlignment;
      }

      ///
      VerticalAlignment::Enum VerticalAlignment() const
      {
         return mVerticalAlignment;
      }

      ///
      void SetVerticalAlignment(VerticalAlignment::Enum verticalAlignment)
      {
         mVerticalAlignment = verticalAlignment;
      }

      ///
      Scaling::Enum Scaling() const
      {
         return mScaling;
      }

      ///
      void SetScaling(Scaling::Enum scaling)
      {
         mScaling = scaling;
      }

      ///
      Int32 FocusPriority() const
      {
         return mFocusPriority;
      }

      ///
      void SetFocusPriority(Int32 focusPriority)
      {
         mFocusPriority = focusPriority;
      }

   private:
      UInt32 mPriority;
      Modality::Enum mModality;
      UInt32 mPresentationTime;
      UInt32 mMinimumPresentationTime;
      UInt32 mValidityPeriod;
      HorizontalAlignment::Enum mHorizontalAlignment;
      VerticalAlignment::Enum mVerticalAlignment;
      Scaling::Enum mScaling;
      Int32 mFocusPriority;
};


/// @}
}


#endif
