/* ***************************************************************************************
* FILE:          IKeyHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IKeyHandler.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_Plugin_IKeyHandler_h)
#define ScreenBroker_Plugin_IKeyHandler_h

#include <ScreenBroker/Plugin/IScreenBrokerPlugin.h>
#include <ScreenBroker/KeyState.h>

namespace ScreenBroker {
class ServiceRequestArg;
/// @addtogroup ScreenBrokerPlugin
/// @{

/**
 * @brief The IKeyHandler class defines the interace of for a KeyHandler plugin.
 *
 * The KeyHandler plugin is triggered by the screen broker when a key event shall
 * be notified to a client which is holding the focused surface.
 */
class IKeyHandler : public IScreenBrokerPlugin
{
   public:
      SCREENBROKER_PLUGIN_STATIC_HEADER(KeyHandler)

      /**
       * @brief Returns the identification of a plugin instance.
       *
       * @return The identification of the plugin instance.
       */
      virtual PluginId::Enum GetId() const
      {
         return Id();
      }

      /**
       * @brief Returns the name of a plugin instance.
       *
       * @return Name of the plugin instance.
       */
      virtual const Char* GetName() const
      {
         return Name();
      }

      /**
       * @brief Gives a feedback if respective key was consumed by a client or not.
       *
       * @param userData User data which may give additional information from application to plugin.
       * @param keyCode 32bit code of the key event.
       * @param keyState The state of the key event.
       * @param consumed True, if the key event was already consumed,
       *                 false otherwise.
       */
      virtual void KeyFeedback(UInt32 userData,
                               UInt32 keyCode,
                               KeyState::Enum keyState,
                               bool consumed) = 0;
};


/// @}
}


#endif
