/* ***************************************************************************************
* FILE:          IConfigurator.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  IConfigurator.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_Plugin_IConfigurator_h)
#define ScreenBroker_Plugin_IConfigurator_h

#include <ScreenBroker/Plugin/IScreenBrokerPlugin.h>
#include <list>
#include <vector>
#include <string>

#include "BaseContract/generated/BaseTypes_SurfaceLayerIds.h"

namespace ScreenBroker {
/// @addtogroup ScreenBrokerPlugin
/// @{

/**
 * @brief The IConfigurator class defines the interace of for a Configurator plugin.
 *
 * The Configurator plugin is dedicated to provide a mapping between display alias and real display ids
 */
class IConfigurator : public IScreenBrokerPlugin
{
   public:
      SCREENBROKER_PLUGIN_STATIC_HEADER(Configurator)

      /**
       * @brief Returns the identification of a plugin instance.
       *
       * @return The identification of the plugin instance.
       */
      virtual PluginId::Enum GetId() const
      {
         return Id();
      }

      /**
       * @brief Returns the name of a plugin instance.
       *
       * @return Name of the plugin instance.
       */
      virtual const Char* GetName() const
      {
         return Name();
      }

      /**
       * @brief get real display id from display alias
       *
       * @param alias for the display to find the real display id for
       * @param id reference to carry the real display id in case of sucessfull apping
       *
       * @return true in case of successful mapping, false otherwise
       */
      virtual bool GetDisplayIdFromAlias(hmibase::DisplayAliasEnum alias, UInt& id) = 0;

      /**
       * @brief get display alias from real display id
       *
       * @param id for the real display to find the display alias for
       * @param alias reference to carry the display alias in case of sucessfull apping
       *
       * @return true in case of successful mapping, false otherwise
       */
      virtual bool GetDisplayAliasFromId(UInt32 id, hmibase::DisplayAliasEnum& alias) = 0;

      /**
       * @brief get ScreenLayouts.xml path
       *
       * @return path of the xmls if available else empty
       */
      virtual std::string GetScreenLayoutsXmlPath() = 0;
};


/// @}
}


#endif
