/* ***************************************************************************************
* FILE:          DimensionArg.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DimensionArg.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_DimensionArg_h)
#define ScreenBroker_DimensionArg_h

#include <ScreenBroker/ScreenBroker.h>

namespace ScreenBroker {
/// @addtogroup ScreenBrokerCommon
/// @{

/**
 * @brief The PopupPresentationArg struct serves as container for dimension values.
 */
struct DimensionArg
{
      DimensionArg()
         : mWidth(0),
           mHeight(0)
      {
      }

      DimensionArg(UInt32 width,
                   UInt32 height)
         : mWidth(width),
           mHeight(height)
      {}

      DimensionArg(const DimensionArg& rhs) : mWidth(rhs.Width()), mHeight(rhs.Height())
      {}

      DimensionArg& operator = (const DimensionArg& rhs)
      {
        if (this != &rhs) {
            mWidth = rhs.mWidth;
            mHeight = rhs.mHeight;
        }
        return *this;
      }

      ///
      UInt32 Width() const
      {
         return mWidth;
      }

      ///
      UInt32 Height() const
      {
         return mHeight;
      }

   private:
      UInt32 mWidth;
      UInt32 mHeight;
};


/// @}
}


#endif
