/* ***************************************************************************************
* FILE:          Connection.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Connection.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_Connection_h)
#define ScreenBroker_Connection_h

#include <ScreenBroker/ScreenBroker.h>

namespace ScreenBroker {
/// @addtogroup ScreenBrokerCommon
/// @{

/**
 * @brief The Connection class provides specific information for client service communication.
 */
class Connection
{
   public:
      /**
       * @brief Request service name (DBus) for screen broker.
       *
       * @return Service name for screen broker.
       */
      static const Char* ServiceName()
      {
         return "at.feat.screenbroker";
      }

      /**
       * @brief Request service path (DBus) for screen broker.
       *
       * @return Service path for screen broker.
       */
      static const Char* ServicePath()
      {
         return "/at/feat/screenbroker";
      }
};


/// @}
}


#endif
