/* ***************************************************************************************
* FILE:          ClientUtil.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ClientUtil.cpp is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


// =============================================================================
// GCC built-in functions for atomic memory access '__sync_fetch_and_add' is not
// known to lint -> ignore lint errors/warnings.
// The lint warnings 505 and 550 are follow-up errors coming from lint error 40.
//lint -esym(40, __sync_fetch_and_add)   "Undeclared identifier"
//lint -efunc(505, ScreenBroker::ClientUtil::GenerateRequestId)   "Redundant left argument to comma"
//lint -esym(550, sRequestId)   "Symbol not accessed"
// =============================================================================

#include "Client.h"
#include "ClientUtil.h"


namespace ScreenBroker {
//    // SCREENBROKER_LOG_SET_REALM(ScreenBroker::LogRealm::ScreenBrokerClient);

// ------------------------------------------------------------------------
UInt ClientUtil::GenerateRequestId()
{
   static UInt sRequestId = 0;
   return static_cast<UInt>(::__sync_fetch_and_add(&sRequestId, 1));
}


}
