/* ***************************************************************************************
* FILE:          AsfServiceProxyAdaptor.h
* SW-COMPONENT:  HMI-BASE
* DESCRIPTION:  AsfServiceProxyAdaptor.h is part of HMI-Base ScreenBroker
* COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "asf/core/BaseComponent.h"
#include "bosch/cm/ai/hmi/screenbroker/ServiceProxy.h"

namespace ScreenBroker {
namespace Internal {

struct ActionPayload
{
   const std::string _clientId;
   uint32_t  _actionId;
   uint32_t _actionData;

   ActionPayload(const std::string& clientId, uint32_t actionId, uint32_t actionData) :
      _clientId(clientId),
      _actionId(actionId),
      _actionData(actionData)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const ActionPayload& payload)
   {
      os << payload._clientId;
      os << payload._actionId;
      os << payload._actionData;

      return os;
   }
};


struct ActivateApplicationPayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;
   uint32_t _surfaceId;
   uint32_t _entryCustomAnimationType;
   uint32_t _exitCustomAnimationType;

   ActivateApplicationPayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg, uint32_t surfaceId, uint32_t entryCustomAnimationType, uint32_t exitCustomAnimationType) :
      _clientId(clientId),
      _requestArg(requestArg),
      _surfaceId(surfaceId),
      _entryCustomAnimationType(entryCustomAnimationType),
      _exitCustomAnimationType(exitCustomAnimationType)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const ActivateApplicationPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();
      os << payload._surfaceId;
      os << payload._entryCustomAnimationType;
      os << payload._exitCustomAnimationType;

      return os;
   }
};


struct ClearPopupFilterPayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

   ClearPopupFilterPayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg) :
      _clientId(clientId),
      _requestArg(requestArg)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const ClearPopupFilterPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();

      return os;
   }
};


struct CloseOnExternalTouchPayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;

   CloseOnExternalTouchPayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg) :
      _clientId(clientId),
      _requestArg(requestArg)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const CloseOnExternalTouchPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();

      return os;
   }
};


struct DeregisterSurfacePayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;
   bool _sendToIlm;
   uint32_t _surfaceId;

   DeregisterSurfacePayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg, bool sendToIlm, uint32_t surfaceId) :
      _clientId(clientId),
      _requestArg(requestArg),
      _sendToIlm(sendToIlm),
      _surfaceId(surfaceId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const DeregisterSurfacePayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();
      os << payload._sendToIlm;
      os << payload._surfaceId;

      return os;
   }
};


struct GetDisplayIdPayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;
   uint32_t _screenAreaId;

   GetDisplayIdPayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg, uint32_t screenAreaId) :
      _clientId(clientId),
      _requestArg(requestArg),
      _screenAreaId(screenAreaId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const GetDisplayIdPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();
      os << payload._screenAreaId;

      return os;
   }
};


struct GetPreferredDimensionsPayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;
   uint32_t _screenAreaId;

   GetPreferredDimensionsPayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg, uint32_t screenAreaId) :
      _clientId(clientId),
      _requestArg(requestArg),
      _screenAreaId(screenAreaId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const GetPreferredDimensionsPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();
      os << payload._screenAreaId;

      return os;
   }
};


struct HidePopupPayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;
   uint32_t _surfaceId;

   HidePopupPayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg, uint32_t surfaceId) :
      _clientId(clientId),
      _requestArg(requestArg),
      _surfaceId(surfaceId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const HidePopupPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();
      os << payload._surfaceId;

      return os;
   }
};


struct KeyFeedbackPayload
{
   const std::string _clientId;
   uint32_t _userData;
   uint32_t  _keyCode;
   bosch::cm::ai::hmi::screenbroker::Types::KeyState _keyState;
   bool _consumed;

   KeyFeedbackPayload(const std::string& clientId, uint32_t userData, uint32_t keyCode, bosch::cm::ai::hmi::screenbroker::Types::KeyState keyState, bool consumed) :
      _clientId(clientId),
      _userData(userData),
      _keyCode(keyCode),
      _keyState(keyState),
      _consumed(consumed)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const KeyFeedbackPayload& payload)
   {
      os << payload._clientId;
      os << payload._userData;
      os << payload._keyCode;
      os << payload._keyState;
      os << payload._consumed;

      return os;
   }
};


struct RegisterSurfacePayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;
   uint32_t _screenAreaId;
   uint32_t _surfaceId;

   RegisterSurfacePayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg, uint32_t screenAreaId,  uint32_t surfaceId) :
      _clientId(clientId),
      _requestArg(requestArg),
      _screenAreaId(screenAreaId),
      _surfaceId(surfaceId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const RegisterSurfacePayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();
      os << payload._screenAreaId;
      os << payload._surfaceId;

      return os;
   }
};


struct RequestCurrentStatusPayload
{
   const std::string _clientId;
   uint32_t  _requestId;

   RequestCurrentStatusPayload(const std::string& clientId, uint32_t requestId) :
      _clientId(clientId),
      _requestId(requestId)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const RequestCurrentStatusPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestId;

      return os;
   }
};


struct SetInputFocusPayload
{
   const std::string _clientId;
   uint32_t _surfaceId;
   bool _keyboardFocus;
   bool _pointerFocus;
   int32_t _priority;
   uint32_t _focusData;

   SetInputFocusPayload(const std::string& clientId, uint32_t surfaceId, bool keyboardFocus, bool pointerFocus, int32_t priority, uint32_t focusData) :
      _clientId(clientId),
      _surfaceId(surfaceId),
      _keyboardFocus(keyboardFocus),
      _pointerFocus(pointerFocus),
      _priority(priority),
      _focusData(focusData)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SetInputFocusPayload& payload)
   {
      os << payload._clientId;
      os << payload._surfaceId;
      os << payload._keyboardFocus;
      os << payload._pointerFocus;
      os << payload._priority;
      os << payload._focusData;

      return os;
   }
};


struct SetPopupFilterPayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;
   bool _disableAll;
   bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg _popupPresArg;

   SetPopupFilterPayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg, bool disableAll, bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg popupPresArg) :
      _clientId(clientId),
      _requestArg(requestArg),
      _disableAll(disableAll),
      _popupPresArg(popupPresArg)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SetPopupFilterPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();
      os << payload._disableAll;
      os << payload._popupPresArg.getPriority();
      os << payload._popupPresArg.getModality();
      os << payload._popupPresArg.getPresentationTime();
      os << payload._popupPresArg.getMinimumPresentationTime();
      os << payload._popupPresArg.getValidityPeriod();
      os << payload._popupPresArg.getHorizontalAlignment();
      os << payload._popupPresArg.getVerticalAlignment();
      os << payload._popupPresArg.getScaling();
      os << payload._popupPresArg.getFocusPriority();

      return os;
   }
};


struct ShowPopupPayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;
   uint32_t _surfaceId;
   bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg _popupPresArg;

   ShowPopupPayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg, uint32_t surfaceId, bosch::cm::ai::hmi::screenbroker::Arguments::PopupPresentationArg popupPresArg) :
      _clientId(clientId),
      _requestArg(requestArg),
      _surfaceId(surfaceId),
      _popupPresArg(popupPresArg)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const ShowPopupPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();
      os << payload._surfaceId;
      os << payload._popupPresArg.getPriority();
      os << payload._popupPresArg.getModality();
      os << payload._popupPresArg.getPresentationTime();
      os << payload._popupPresArg.getMinimumPresentationTime();
      os << payload._popupPresArg.getValidityPeriod();
      os << payload._popupPresArg.getHorizontalAlignment();
      os << payload._popupPresArg.getVerticalAlignment();
      os << payload._popupPresArg.getScaling();
      os << payload._popupPresArg.getFocusPriority();

      return os;
   }
};


struct AttachandAnimateLayerPayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;
   uint32_t _layerId;
   std::vector<uint32_t> _surfaceList;
   uint32_t _animationType;
   uint32_t _hint;

   AttachandAnimateLayerPayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg, uint32_t layerId, std::vector<uint32_t> surfaceList, uint32_t animationType, uint32_t hint) :
      _clientId(clientId),
      _requestArg(requestArg),
      _layerId(layerId),
      _surfaceList(surfaceList),
      _animationType(animationType),
      _hint(hint)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const AttachandAnimateLayerPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();
      os << payload._layerId;
      for (size_t i = 0; i < payload._surfaceList.size(); ++i)
      {
         os << payload._surfaceList[i];
      }
      os << payload._animationType;
      os << payload._hint;

      return os;
   }
};


struct StartAnimationPayload
{
   const std::string _clientId;
   ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg _requestArg;
   uint32_t _surfaceId;
   uint32_t _animationType;
   uint32_t _hint;

   StartAnimationPayload(const std::string& clientId, ::bosch::cm::ai::hmi::screenbroker::Arguments::RequestArg requestArg, uint32_t surfaceId, uint32_t animationType, uint32_t hint) :
      _clientId(clientId),
      _requestArg(requestArg),
      _surfaceId(surfaceId),
      _animationType(animationType),
      _hint(hint)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const StartAnimationPayload& payload)
   {
      os << payload._clientId;
      os << payload._requestArg.getRequestId();
      os << payload._requestArg.getAppId();
      os << payload._requestArg.getUserData();
      os << payload._surfaceId;
      os << payload._animationType;
      os << payload._hint;

      return os;
   }
};


class AsfServiceProxy;

class AsfServiceProxyAdaptor :
   public ::asf::core::LocalMessageCallbackIF1< ActionPayload >,
   public ::asf::core::LocalMessageCallbackIF1< ActivateApplicationPayload >,
   public ::asf::core::LocalMessageCallbackIF1< ClearPopupFilterPayload >,
   public ::asf::core::LocalMessageCallbackIF1< CloseOnExternalTouchPayload >,
   public ::asf::core::LocalMessageCallbackIF1< DeregisterSurfacePayload >,
   public ::asf::core::LocalMessageCallbackIF1< GetDisplayIdPayload >,
   public ::asf::core::LocalMessageCallbackIF1< GetPreferredDimensionsPayload >,
   public ::asf::core::LocalMessageCallbackIF1< HidePopupPayload >,
   public ::asf::core::LocalMessageCallbackIF1< KeyFeedbackPayload >,
   public ::asf::core::LocalMessageCallbackIF1< RegisterSurfacePayload >,
   public ::asf::core::LocalMessageCallbackIF1< RequestCurrentStatusPayload >,
   public ::asf::core::LocalMessageCallbackIF1< SetInputFocusPayload >,
   public ::asf::core::LocalMessageCallbackIF1< SetPopupFilterPayload >,
   public ::asf::core::LocalMessageCallbackIF1< ShowPopupPayload >,
   public ::asf::core::LocalMessageCallbackIF1< StartAnimationPayload >,
   public ::asf::core::LocalMessageCallbackIF1< AttachandAnimateLayerPayload >


{
   public:
      friend class AsfServiceProxy;

      AsfServiceProxyAdaptor();
      virtual ~AsfServiceProxyAdaptor();

      void setBaseComponent(::asf::core::BaseComponent* baseComponent);
      ::asf::core::BaseComponent* getBaseComponent();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ActionPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ActivateApplicationPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ClearPopupFilterPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < CloseOnExternalTouchPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < DeregisterSurfacePayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < GetDisplayIdPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < GetPreferredDimensionsPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < HidePopupPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < KeyFeedbackPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RegisterSurfacePayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestCurrentStatusPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < SetInputFocusPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < SetPopupFilterPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ShowPopupPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < StartAnimationPayload > >& payload);
      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < AttachandAnimateLayerPayload > >& payload);

   private:

      void setProxy(::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy > proxy)
      {
         _proxy = proxy;
      }

      ::asf::core::BaseComponent* _baseComponent;
      ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy > _proxy;
};


}
}//namespace
