/* ***************************************************************************************
 * FILE:          AsfServiceProxyAdaptor.cpp
 * SW-COMPONENT:  HMI-BASE
 * DESCRIPTION:  AsfServiceProxyAdaptor.cpp is part of HMI-Base ScreenBroker
 * COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
 *
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
#include "AsfServiceProxyAdaptor.h"

namespace ScreenBroker {
namespace Internal {

AsfServiceProxyAdaptor::AsfServiceProxyAdaptor() : _baseComponent(0)
{
}


AsfServiceProxyAdaptor::~AsfServiceProxyAdaptor()
{
   _baseComponent = 0;
}


void AsfServiceProxyAdaptor::setBaseComponent(::asf::core::BaseComponent* baseComponent)
{
   _baseComponent = baseComponent;
}


::asf::core::BaseComponent* AsfServiceProxyAdaptor::getBaseComponent()
{
   return _baseComponent;
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ActionPayload > >& payload)
{
   _proxy->sendActionRequest(payload->get0()._clientId, payload->get0()._actionId, payload->get0()._actionData);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ActivateApplicationPayload > >& payload)
{
   _proxy->sendActivateApplicationRequest(payload->get0()._clientId, payload->get0()._requestArg, payload->get0()._surfaceId, payload->get0()._entryCustomAnimationType, payload->get0()._exitCustomAnimationType);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ClearPopupFilterPayload > >& payload)
{
   _proxy->sendClearPopupFilterRequest(payload->get0()._clientId, payload->get0()._requestArg);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < CloseOnExternalTouchPayload > >& payload)
{
   _proxy->sendCloseOnExternalTouchRequest(payload->get0()._clientId, payload->get0()._requestArg);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < DeregisterSurfacePayload > >& payload)
{
   _proxy->sendDeregisterSurfaceRequest(payload->get0()._clientId, payload->get0()._requestArg, payload->get0()._surfaceId, payload->get0()._sendToIlm);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < GetDisplayIdPayload > >& payload)
{
   _proxy->sendGetDisplayIdRequest(payload->get0()._clientId, payload->get0()._requestArg, payload->get0()._screenAreaId);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < GetPreferredDimensionsPayload > >& payload)
{
   _proxy->sendGetPreferredDimensionsRequest(payload->get0()._clientId, payload->get0()._requestArg, payload->get0()._screenAreaId);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < HidePopupPayload > >& payload)
{
   _proxy->sendHidePopupRequest(payload->get0()._clientId, payload->get0()._requestArg, payload->get0()._surfaceId);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < KeyFeedbackPayload > >& payload)
{
   _proxy->sendKeyFeedbackRequest(payload->get0()._clientId, payload->get0()._userData, payload->get0()._keyCode, payload->get0()._keyState, payload->get0()._consumed);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RegisterSurfacePayload > >& payload)
{
   _proxy->sendRegisterSurfaceRequest(payload->get0()._clientId, payload->get0()._requestArg, payload->get0()._screenAreaId, payload->get0()._surfaceId);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < RequestCurrentStatusPayload > >& payload)
{
   _proxy->sendRequestCurrentStatusRequest(payload->get0()._clientId, payload->get0()._requestId);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < SetInputFocusPayload > >& payload)
{
   _proxy->sendSetInputFocusRequest(payload->get0()._clientId, payload->get0()._surfaceId, payload->get0()._keyboardFocus, payload->get0()._pointerFocus, payload->get0()._priority, payload->get0()._focusData);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < SetPopupFilterPayload > >& payload)
{
   _proxy->sendSetPopupFilterRequest(payload->get0()._clientId, payload->get0()._requestArg, payload->get0()._disableAll, payload->get0()._popupPresArg);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < ShowPopupPayload > >& payload)
{
   _proxy->sendShowPopupRequest(payload->get0()._clientId, payload->get0()._requestArg, payload->get0()._surfaceId, payload->get0()._popupPresArg);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < StartAnimationPayload > >& payload)
{
   _proxy->sendStartAnimationRequest(payload->get0()._clientId, payload->get0()._requestArg, payload->get0()._surfaceId, payload->get0()._animationType, payload->get0()._hint);
}


void AsfServiceProxyAdaptor::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1 < AttachandAnimateLayerPayload > >& payload)
{
   _proxy->sendAttachandAnimateLayerRequest(payload->get0()._clientId, payload->get0()._requestArg, payload->get0()._layerId, payload->get0()._surfaceList, payload->get0()._animationType, payload->get0()._hint);
}


}
} //namespace
