/* ***************************************************************************************
* FILE:          AsfServiceProxy.h
* SW-COMPONENT:  HMI-BASE
* DESCRIPTION:  AsfServiceProxy.h is part of HMI-Base ScreenBroker
* COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(ScreenBroker_Client_AsfServiceProxy_h)
#define ScreenBroker_Client_AsfServiceProxy_h

#include <string>
#include <ScreenBroker/ScreenBroker.h>
#include <ScreenBroker/Plugin/IScreenBrokerPlugin.h>
#include <ScreenBroker/Client/ServiceProxy.h>
#include <ScreenBroker/KeyState.h>
#include <ScreenBroker/SurfaceState.h>
#include "bosch/cm/ai/hmi/screenbroker/ServiceProxy.h"
#include "bosch/cm/ai/hmi/screenbroker/Arguments.h"
#include "AsfServiceProxyAdaptor.h"


namespace ScreenBroker {
namespace Internal {

class ServiceApi;

class AsfServiceProxy : public ServiceProxy
   , public asf::core::ServiceAvailableIF
   , public bosch::cm::ai::hmi::screenbroker::Service::OnCurrentStatusCallbackIF
   , public bosch::cm::ai::hmi::screenbroker::Service::OnLayerStateChangedCallbackIF
   , public bosch::cm::ai::hmi::screenbroker::Service::OnSurfaceStateChangedCallbackIF
   , public bosch::cm::ai::hmi::screenbroker::Service::OnGetPreferredDimensionsCallbackIF
   , public bosch::cm::ai::hmi::screenbroker::Service::OnKeyEventCallbackIF
   , public bosch::cm::ai::hmi::screenbroker::Service::OnErrorCallbackIF
   , public bosch::cm::ai::hmi::screenbroker::Service::OnCloseOnExternalTouchCallbackIF
   , public bosch::cm::ai::hmi::screenbroker::Service::OnGetDisplayIdCallbackIF
   , public bosch::cm::ai::hmi::screenbroker::Service::VersionCallbackIF
   , public bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersCallbackIF
{
   public:

      // AsfServiceProxy();
      virtual ~AsfServiceProxy();
      ///
      static AsfServiceProxy* DoCreate(ClientApi* clientApi, std::string& clientId, ::asf::core::BaseComponent* baseComponent = 0);
      ///
      static const Char* GetClientId();

      ///
      bool IsEventAddressee(const Char* receiverId) const
      {
         return mClientId.compare(receiverId) == 0;
      }

      ///
      void Reset();

      template< typename T0 >
      act_t sendLocalMessageAsfService(const T0& t0)
      {
         return (_baseComponent != 0) ? _baseComponent->sendLocalMessage<T0>(_AsfServiceProxyAdaptor, t0) : 0;
      }

      void setBaseComponent(::asf::core::BaseComponent* baseComponent);

      ///
      virtual const Char* GetVersion();

      ///
      virtual bool GetBuildInLayerInfo(std::vector<BuildInLayerInfo>& info);

      /* START: can be called from different thread */
      ///
      virtual void GetDisplayId(const RequestArg& requestArg,
                                UInt32 screenAreaId);

      ///
      virtual void GetPreferredDimensions(const RequestArg& requestArg,
                                          UInt32 screenAreaId);

      ///
      virtual void RegisterSurface(const RequestArg& requestArg,
                                   UInt32 screenAreaId,
                                   UInt32 surfaceId);

      ///
      virtual void DeregisterSurface(const RequestArg& requestArg,
                                     UInt32 surfaceId,
                                     bool sendToIlm);

      ///
      virtual void ActivateApplication(const RequestArg& requestArg,
                                       UInt32 surfaceId,
                                       UInt32 entryCustomAnimationType,
                                       UInt32 exitCustomAnimationType);

      virtual void StartAnimation(const RequestArg& requestArg,
                                  UInt32 surfaceId,
                                  UInt32 animationType,
                                  UInt32 hint);
      ///
      virtual void StartLayerAnimation(const RequestArg& requestArg,
                                       UInt32 layerId,
                                       std::vector<UInt32> surfaceIdList,
                                       UInt32 animationType,
                                       UInt32 hint);
      ///
      virtual void ShowPopup(const RequestArg& requestArg,
                             UInt32 surfaceId,
                             const PopupPresentationArg& popupPresentationArg);

      ///
      virtual void HidePopup(const RequestArg& requestArg,
                             UInt32 surfaceId);

      ///
      virtual void CloseOnExternalTouch(const RequestArg& requestArg);

      ///
      virtual void SetPopupFilter(const RequestArg& requestArg,
                                  bool disableAll,
                                  const PopupPresentationArg& popupPresentationArg);

      ///
      virtual void ClearPopupFilter(const RequestArg& requestArg);

      ///
      virtual void KeyFeedback(UInt32 userData,
                               UInt32 keyCode,
                               KeyState::Enum keyState,
                               bool consumed);

      ///
      virtual void Action(UInt32 actionId, UInt32 actionData);

      ///
      virtual void SetInputFocus(UInt32 surfaceId,
                                 bool keyboardFocus,
                                 bool pointerFocus,
                                 Int32 priority,
                                 UInt32 focusData);

      ///
      virtual void RequestCurrentStatus(UInt32 requestId);

      /* END: can be called from different thread */

      // ServiceAvailableIF
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // Callback 'OnCloseOnExternalTouchCallbackIF'

      virtual void onOnCloseOnExternalTouchError(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnCloseOnExternalTouchError >& error);
      virtual void onOnCloseOnExternalTouchSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnCloseOnExternalTouchSignal >& signal);

      // Callback 'OnCurrentStatusCallbackIF'

      virtual void onOnCurrentStatusError(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnCurrentStatusError >& error);
      virtual void onOnCurrentStatusSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnCurrentStatusSignal >& signal);

      // Callback 'OnLayerStateChangedCallbackIF'

      virtual void onOnLayerStateChangedError(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnLayerStateChangedError >& error);
      virtual void onOnLayerStateChangedSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnLayerStateChangedSignal >& signal);

      // Callback 'OnErrorCallbackIF'

      virtual void onOnErrorError(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnErrorError >& error);
      virtual void onOnErrorSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnErrorSignal >& signal);

      // Callback 'OnGetDisplayIdCallbackIF'

      virtual void onOnGetDisplayIdError(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnGetDisplayIdError >& error);
      virtual void onOnGetDisplayIdSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnGetDisplayIdSignal >& signal);

      // Callback 'OnGetPreferredDimensionsCallbackIF'

      virtual void onOnGetPreferredDimensionsError(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnGetPreferredDimensionsError >& error);
      virtual void onOnGetPreferredDimensionsSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnGetPreferredDimensionsSignal >& signal);

      // Callback 'OnKeyEventCallbackIF'

      virtual void onOnKeyEventError(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnKeyEventError >& error);
      virtual void onOnKeyEventSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnKeyEventSignal >& signal);

      // Callback 'OnSurfaceStateChangedCallbackIF'

      virtual void onOnSurfaceStateChangedError(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnSurfaceStateChangedError >& error);
      virtual void onOnSurfaceStateChangedSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::OnSurfaceStateChangedSignal >& signal);

      // callback versionCallbackIF
      virtual void onVersionError(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::VersionError >& error);
      virtual void onVersionUpdate(const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy>& proxy, const ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::VersionUpdate >& update);

      //
      void onBuildInLayersError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersError >& error);
      void onBuildInLayersUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::ai::hmi::screenbroker::Service::BuildInLayersUpdate >& update);

   private:
      std::string& mClientId;
      std::string mversion;
      act_t  _SBServiceProxy_CurrentStatus_RegId;
      act_t  _SBServiceProxy_LayerStateChanged_RegId;
      act_t  _SBServiceProxy_SurfaceStateChanged_RegId;
      act_t  _SBServiceProxy_GetPreferredDimensions_RegId;
      act_t  _SBServiceProxy_KeyEvent_RegId;
      act_t  _SBServiceProxy_Error_RegId;
      act_t  _SBServiceProxy_CloseOnExternalTouch_RegId;
      act_t  _SBServiceProxy_GetDisplayId_RegId;
      act_t  _SBServiceProxy_Version_RegId;

      ::asf::core::BaseComponent* _baseComponent;
      ::boost::shared_ptr< bosch::cm::ai::hmi::screenbroker::Service::ServiceProxy> _SBServiceProxy;

      AsfServiceProxy(std::string& clientId);

      friend class ServiceApi;

   protected:
      ///
      virtual void DoInit();
      ///
      virtual void DoRun();
      ///
      virtual void DoTerminate();

      ScreenBroker::Internal::AsfServiceProxyAdaptor _AsfServiceProxyAdaptor;
};


}
}


#endif // ScreenBroker_Client_AsfServiceProxy_h
