/* ***************************************************************************************
* FILE:          BuildInLayerInfo.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  BuildInLayerInfo.h is part of HMI-Base ScreenBroker
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */


#if !defined(ScreenBroker_BuildInLayerInfo_h)
#define ScreenBroker_BuildInLayerInfo_h

#include <ScreenBroker/ScreenBroker.h>
#include <ScreenBroker/DimensionArg.h>
#include <string>

namespace ScreenBroker {
/// @addtogroup ScreenBrokerCommon
/// @{

/**
 * @brief 
 */
struct BuildInLayerInfo
{
      BuildInLayerInfo()
         : _layerId(0),
           _surfaceId(0),
           _screenId(0)
      {
      }

      BuildInLayerInfo(UInt32 layerId,
                       UInt32 surfaceId,
                       UInt32 screenId,
                       const std::string& connectorName,
                       DimensionArg dimension)
         : _layerId(layerId),
           _surfaceId(surfaceId),
           _screenId(screenId),
           _connectorName(connectorName),
           _dimension(dimension)
      {}


      ///
      UInt32 LayerId() const
      {
         return _layerId;
      }

      ///
      UInt32 SurfaceId() const
      {
         return _surfaceId;
      }

      ///
      UInt32 ScreenId() const
      {
         return _screenId;
      }

      ///
      const std::string& ConnectorName() const
      {
         return _connectorName;
      }
      ///
      DimensionArg Dimension() const
      {
         return _dimension;
      }

   private:
      UInt32 _layerId;
      UInt32 _surfaceId;
      UInt32 _screenId;
      std::string _connectorName;
      DimensionArg _dimension;
};


/// @}
}


#endif
