/* ***************************************************************************************
* FILE:          TraverseViews.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TraverseViews.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_TRAVERSEVIEWS_H
#define HMIBASE_TRACE_COMMAND_TRAVERSEVIEWS_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct TraverseViewsPayload
{
   std::string appName;
   std::string visitors;
   std::string viewName;

   TraverseViewsPayload(const char* a, const char* v, const char* vn) : appName(a), visitors(v), viewName(vn)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const TraverseViewsPayload& payload)
   {
      os << payload.appName;
      os << payload.visitors;
      os << payload.viewName;
      return os;
   }
};


class TraverseViews :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< TraverseViewsPayload >
{
   private:

      TraverseViews();

   public:
      virtual ~TraverseViews();

      static TraverseViews& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< TraverseViewsPayload > >& payload);

      static void TraceCommand(const char* appName, const char* visitors, const char* viewName = 0);
};


}
}


}
#endif
