/* ***************************************************************************************
* FILE:          TraverseViews.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TraverseViews.cpp is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "TraverseViews.h"
#include "hmibase/trace/HMIBaseTraceCmds.h"
#include "bosch/cm/ai/hmi/appctrl/trace/CommandsConst.h"
#include <hmibase/util/StringUtils.h>

#include "hmibase/trace/HMIBaseTraceCmds_Trace.h"

using namespace hmibase::trace;

#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_TRACEDAEMON
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TRACE_CHANNEL               TR_CHANNEL_HMI_BASE
#define ETG_I_TTFIS_CMD_PREFIX            "HMI_"
#define ETG_I_FILE_PREFIX                 hmibase::trace::command::TraverseViews::
#include "trcGenProj/Header/TraverseViews.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::appctrl::trace::Commands;

namespace hmibase {
namespace trace {
namespace command {

TraverseViews& TraverseViews::GetInstance()
{
   static TraverseViews theInstance;
   return theInstance;
}


TraverseViews::TraverseViews()
{
   ETG_I_REGISTER_FILE();
}


TraverseViews::~TraverseViews()
{
   ETG_I_UNREGISTER_FILE();
}


void TraverseViews::onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< TraverseViewsPayload > >& payload)
{
   if (_stub)
   {
      std::vector<int> pids;
      std::vector<std::string > param;
      param.push_back(payload->get0().visitors);
      if (payload->get0().viewName.empty() == false)
      {
         ETG_TRACE_FATAL(("HMIBaseTraceCmds::TraverseViews: viewName=%s", payload->get0().viewName));
      }
      else
      {
         ETG_TRACE_FATAL(("HMIBaseTraceCmds::TraverseViews"));
      }
      param.push_back(payload->get0().viewName);

      if (_stub->getClientsPid(payload->get0().appName, pids))
      {
         for (std::vector<int>::iterator it = pids.begin(); it != pids.end(); ++it)
         {
            _stub->sendTraceQuerySignal(TraceQueryData(*it, traceQueryId__TRAVERSE_VIEWS, param));
         }
      }
      else
      {
         ETG_TRACE_FATAL(("Unknown application '%s'", payload->get0().appName));
      }
   }
}


ETG_I_CMD_DEFINE((TraceCommand, "TraverseViews %20s %200s", ETG_I_STRING, ETG_I_STRING))
ETG_I_CMD_DEFINE((TraceCommand, "TraverseViews %20s %80s %120s", ETG_I_STRING, ETG_I_STRING, ETG_I_STRING))
void TraverseViews::TraceCommand(const char* appName, const char* visitors, const char* viewName)
{
   if (GetInstance()._stub)
   {
      TraverseViewsPayload payload(appName, visitors, viewName != 0 ? viewName : "");
      GetInstance()._stub->sendLocalMessage(GetInstance(), payload);
   }
}


}
}


}
