/* ***************************************************************************************
* FILE:          SurfaceGeometryHelper.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SurfaceGeometryHelper.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef HMIBASE_TRACE_COMMAND_SURFACEGEOMETRYHELPER_H
#define HMIBASE_TRACE_COMMAND_SURFACEGEOMETRYHELPER_H

#include <hmibase/util/Geometry.h>
#include <vector>

namespace hmibase {
namespace trace {
namespace command {

class SurfaceGeometryHelper
{
   public:

      struct surfaceTouchGeometry
      {
         int surfaceId;
         ::hmibase::util::geometry::Rect touchableRect;

         surfaceTouchGeometry(unsigned int id, const hmibase::util::geometry::Rect& rect): surfaceId(static_cast<int>(id)), touchableRect(rect) {}
      };

      SurfaceGeometryHelper();
      virtual ~SurfaceGeometryHelper();

      int getPidForSurfaceId(int id);
      bool getSurfaceCluster(std::vector<surfaceTouchGeometry>&);

      void init();

   private:

      static int _ilmInitStatus;
      void removeHiddenTouchArea(std::vector<surfaceTouchGeometry>& surfaceTouchVector);
};


}
}


}
#endif
