/* ***************************************************************************************
* FILE:          StartAnimation.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  StartAnimation.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_StartAnimation_H
#define HMIBASE_TRACE_COMMAND_StartAnimation_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct StartAnimationPayload
{
   unsigned int surfaceId;
   unsigned int animationType;

   StartAnimationPayload(unsigned int surfaceId, unsigned int animationType) : surfaceId(surfaceId), animationType(animationType)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const StartAnimationPayload& payload)
   {
      os << payload.surfaceId;
      os << payload.animationType;
      return os;
   }
};


class StartAnimation :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< StartAnimationPayload >
{
   private:

      StartAnimation();

   public:
      virtual ~StartAnimation();

      static StartAnimation& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< StartAnimationPayload > >& payload);

      static void TraceCommand(unsigned int, unsigned int);
};


}
}


}
#endif
