/* ***************************************************************************************
* FILE:          SimTouchByText.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimTouchByText.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_SIMTOUCHBYTEXT_H
#define HMIBASE_TRACE_COMMAND_SIMTOUCHBYTEXT_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

typedef std::string SimTouchByTextPayload;

class SimTouchByText :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< SimTouchByTextPayload >
{
   private:

      SimTouchByText();

   public:
      virtual ~SimTouchByText();

      static SimTouchByText& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimTouchByTextPayload > >& payload);

      static void TraceCommand(const char* text);
};


}
}


}
#endif
