/* ***************************************************************************************
* FILE:          SimTouchByIndex.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SimTouchByIndex.h is part of HMI-Base framework Library
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HMIBASE_TRACE_COMMAND_SIMTOUCHBYINDEX_H
#define HMIBASE_TRACE_COMMAND_SIMTOUCHBYINDEX_H

#include "asf/core/BaseComponent.h"
#include <string.h>
#include "bosch/cm/ai/hmi/appctrl/trace/Commands.h"
#include "hmibase/trace/command/TraceCmdHandler.h"

namespace hmibase {
namespace trace {
namespace command {

struct SimTouchByIndexPayload
{
   unsigned int listId;
   unsigned int buttonWidgetIdx;

   SimTouchByIndexPayload(unsigned int id, unsigned int idx) : listId(id), buttonWidgetIdx(idx)
   {
   }

   friend std::ostream& operator<<(std::ostream& os, const SimTouchByIndexPayload& payload)
   {
      os << payload.listId;
      os << payload.buttonWidgetIdx;
      return os;
   }
};


class SimTouchByIndex :
   public ::hmibase::trace::command::TraceCmdHandler,
   public ::asf::core::LocalMessageCallbackIF1< SimTouchByIndexPayload >
{
   private:

      SimTouchByIndex();

   public:
      virtual ~SimTouchByIndex();

      static SimTouchByIndex& GetInstance();

      virtual void onLocalMessage(::boost::shared_ptr< asf::core::PayloadTuple1< SimTouchByIndexPayload > >& payload);

      static void TraceCommand(unsigned int listId, unsigned int buttonWidgetIdx);
};


}
}


}
#endif
